%define modname scikit-build
%define pypi_name scikit_build
%define _name skbuild

%def_disable check

Name: python3-module-%modname
Version: 0.18.1
Release: alt1

Summary: Improved build system generator for CPython C/C++/Fortran/Cython extensions
Group: Development/Python3
License: MIT
Url: http://pypi.python.org/pypi/%modname

Vcs: https://github.com/scikit-build/scikit-build.git
Source: https://pypi.io/packages/source/s/%pypi_name/%pypi_name-%version.tar.gz

BuildArch: noarch

Requires: cmake make ninja-build gcc-c++
# skbuild/_compat/tomllib.py
#%if "%__python3_version" <= "3.11"
%if "%(rpmvercmp %_python3_version 3.11)" < "0"
Requires: python3(tomli)
%else
Requires: python3(tomllib)
%endif

# for python w/o distutils
%filter_from_requires /python3(distutils.*)/d
Requires: python3(setuptools._distutils)

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-wheel
BuildRequires: python3(hatchling) python3(hatch-fancy-pypi-readme) python3(hatch-vcs)
%{?_enable_check:BuildRequires: python3-module-pytest
BuildRequires: python3(setuptools) python3(setuptools_scm)
BuildRequires: python3(cython)
BuildRequires: python3(requests) python3(pip)
BuildRequires: cmake make ninja-build gcc-c++ gcc-fortran git}

%description
%summary
Better support is available for additional compilers, build systems,
cross compilation, and locating dependencies and determining their build
requirements.

The scikit-build package is fundamentally just glue between the
setuptools Python module and CMake.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir_noarch
py.test3

%files
%python3_sitelibdir_noarch/%_name/
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc README* CHANGES*


%changelog
