%define _unpackaged_files_terminate_build 1

%define oname scikit-image

%def_disable docs
%def_with check
%def_with pythran

Name: python3-module-%oname
Version: 0.25.2
Release: alt1
Summary: Image processing routines for SciPy
License: BSD-3-Clause and MIT
Group: Development/Python3
Url: https://pypi.org/project/scikit-image/

VCS: https://github.com/scikit-image/scikit-image.git
Source: %name-%version.tar
Patch: scikit-image-0.25.0-version-fix.patch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libgomp-devel
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-Cython
BuildRequires: python3-module-scipy libnumpy-py3-devel
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-wheel
BuildRequires: python3-module-mesonpy
BuildRequires: meson

%if_with pythran
BuildRequires: python3-module-pythran
BuildRequires: libflexiblas-devel
%endif

# for tests
%if_with check
BuildRequires: /usr/bin/xvfb-run
BuildRequires: python3-module-pytest
BuildRequires: python3-module-wavelets python3-module-imageio
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-tifffile
BuildRequires: python3-module-lazy_loader
BuildRequires: python3-module-numpydoc
BuildRequires: python3-module-networkx
BuildRequires: python3-module-pytest-localserver
%endif

# for docs
%if_enabled docs
BuildRequires: xvfb-run
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-sphinx-gallery
BuildRequires: python3-module-sphinx-copybutton
BuildRequires: python3-module-numpydoc
BuildRequires: python3-module-matplotlib-sphinxext
BuildRequires: python3-module-pandas
BuildRequires: python3-module-dask
BuildRequires: python3-module-scikit-learn
BuildRequires: python3-module-seaborn
%endif

%py3_provides skimage
%py3_requires numpy scipy networkx matplotlib

%add_python3_self_prov_path %buildroot%python3_sitelibdir/skimage/data

# optional dependence is not packaged for ALT
%add_python3_req_skip astropy.io

%description
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Image processing algorithms for SciPy, including IO, morphology,
filtering, warping, color manipulation, object detection, etc.

This package contains documentation for %oname.

%prep
%setup
%patch -p1

sed -Ei "1{s@/usr/bin/env python@\%__python3@}" ./skimage/_build_utils/*.py

# For regeneration of cython source
rm -f $(grep -rl '/\* Generated by Cython')

%if_enabled docs
%prepare_sphinx3 doc
ln -s ../objects.inv doc/source/
%endif

%build
export SCIPY_USE_PYTHRAN=0%{?with_pythran}
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
export SCIPY_USE_PYTHRAN=0%{?with_pythran}
%pyproject_install
rm -rf %buildroot%python3_sitelibdir/doc

%if_enabled docs
export PYTHONPATH=%buildroot%python3_sitelibdir
xvfb-run make -C doc pickle PYTHON=python3
xvfb-run make -C doc html PYTHON=python3

install -d %buildroot%python3_sitelibdir/skimage
cp -fR doc/build/pickle %buildroot%python3_sitelibdir/skimage/
%endif

%check
mkdir -p matplotlib
touch matplotlib/matplotlibrc
export XDG_CONFIG_HOME=$(pwd)
export XDG_CACHE_HOME=$PWD
export PYTHONDONTWRITEBYTECODE=1
export PYTEST_ADDOPTS='-p no:cacheprovider'
pushd %buildroot%python3_sitelibdir
# We deselect tests that require network data
 xvfb-run py.test-3 -v \
  --deselect="skimage/data/tests/test_data.py::test_download_all_with_pooch" \
  --deselect="skimage/data/tests/test_data.py::test_eagle" \
  --deselect="skimage/data/tests/test_data.py::test_brain_3d" \
  --deselect="skimage/data/tests/test_data.py::test_cells_3d" \
  --deselect="skimage/data/tests/test_data.py::test_kidney_3d_multichannel" \
  --deselect="skimage/data/tests/test_data.py::test_lily_multichannel" \
  --deselect="skimage/data/tests/test_data.py::test_skin" \
  --deselect="skimage/data/tests/test_data.py::test_vortex" \
  --deselect="skimage/measure/tests/test_blur_effect.py::test_blur_effect_3d" \
  --deselect="skimage/registration/tests/test_masked_phase_cross_correlation.py::test_masked_registration_3d_contiguous_mask" \
  --deselect="skimage/io/tests/test_imageio.py::TestSave::test_imsave_roundtrip[shape1-uint16]" \
%ifarch i586 armh
  --deselect="skimage/measure/tests/test_fit.py::test_ellipse_parameter_stability" \
  --deselect="skimage/util/tests/test_regular_grid.py::test_regular_grid_2d_8" \
  --deselect="skimage/util/tests/test_regular_grid.py::test_regular_grid_3d_8" \
  --deselect="skimage/segmentation/tests/test_quickshift.py::test_grey" \
  --deselect="skimage/morphology/tests/test_misc.py" \
%endif
  skimage/
popd

%files
%doc LICENSE.txt
%doc RELEASE.*
%python3_sitelibdir/skimage
%python3_sitelibdir/scikit_image-%version.dist-info
%if_enabled docs
%exclude %python3_sitelibdir/skimage/pickle
%endif

%if_enabled docs
%files pickles
%python3_sitelibdir/skimage/pickle
%endif

%files docs
%doc doc/examples
%if_enabled docs
%doc doc/build/html
%endif

%changelog
