%define oname serpent

%def_with check

Name: python3-module-%oname
Version: 1.41
Release: alt2
Summary: Serializer for literal Python expressions
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/serpent

# https://github.com/irmen/Serpent.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
%if_with check
BuildRequires: python3-module-attrs
BuildRequires: python3-module-pytz
BuildRequires: python3-module-pytest
%endif

%description
Serpent is a simple serialization library based on ast.literal_eval.

Because it only serializes literals and recreates the objects using
ast.literal_eval(), the serialized data is safe to transport to other
machines (over the network for instance) and de-serialize it there.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# .github/workflows/main-ci.yml
%pyproject_run_pytest -vra tests

%files
%doc README.md
%python3_sitelibdir/%oname.py
%python3_sitelibdir/__pycache__/serpent.cpython-*.pyc
%python3_sitelibdir/%oname-%version.dist-info

%changelog
