%define _unpackaged_files_terminate_build 1
%define pypi_name simplegeneric
%define modname %pypi_name

Name: python3-module-%modname
Version: 0.8.1
Release: alt5
Summary: Simple generic functions (similar to Python's own len(), pickle.dump(), etc.)

Group: Development/Python3
License: Python or ZPLv2.1
Url: https://pypi.org/project/simplegeneric/
Source0: %modname-%version.zip

BuildArch: noarch
BuildRequires: unzip
BuildRequires: rpm-build-python3
# build backend and its deps
BuildRequires: python3-module-setuptools

%description
The simplegeneric module lets you define simple single-dispatch generic
functions, akin to Python's built-in generic functions like len(), iter() and
so on. However, instead of using specially-named methods, these generic
functions use simple lookup tables, akin to those used by e.g. pickle.dump()
and other generic functions found in the Python standard library.

%prep
%setup -n %modname-%version

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_unittest %modname.test_suite

%files
%doc README.txt
%python3_sitelibdir/__pycache__/%modname.cpython*
%python3_sitelibdir/%modname.py
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
