%define oname sip

Name: python3-module-sip6
Version: 6.12.0
Release: alt0.2

Summary: Python3 bindings generator for C/C++ libraries

License: GPLv2, GPLv3 licenses, BSD-like
Group: Development/Python3
URL: http://www.riverbankcomputing.com/software/sip/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar
Patch1: remove-distutils-for-python-3.12.patch
Patch2: alt-toml.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-packaging
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

Conflicts: python3-module-sip5
Conflicts: python3-module-sip-devel
# sip-build runs in a wrong way if old sip is installed
Conflicts: python3-module-sip

%description
SIP is a collection of tools that makes it very easy
to create Python bindings for C and C++ libraries.

SIP comprises a set of build tools and a sip module.
The build tools process a set of specification files
and generates C or C++ code which is then compiled
to create the bindings extension module.
Several extension modules may be installed
in the same Python package.
Extension modules can be built so that they are
independent of the version of Python being used.
In other words a wheel created from them
can be installed with any version of Python starting with v3.5.

The specification files contain a description of the interface
of the C or C++ library, i.e. the classes, methods, functions and variables.
The format of a specification file is almost identical to a C or C++ header file,
so much so that the easiest way of creating a specification file
is to edit a copy of the corresponding header file.

The sip module provides support functions to the automatically generated code.
The sip module is installed as part of the same Python package
as the generated extension modules.
Unlike the extension modules the sip module is specific
to a particular version of Python (e.g. v3.5, v3.6, v3.7, v3.8).

SIP makes it easy to exploit existing C or C++ libraries
in a productive interpretive programming environment.
SIP also makes it easy to take a Python application (maybe a prototype)
and selectively implement parts of the application (maybe for performance reasons) in C or C++.

%package devel
Requires: %name = %EVR
Summary: Development files for SIP 6 (Python 3)
Group: Development/Python3
Requires: python3-devel

%description devel
Development files for SIP 6 (Python 3).


%prep
%setup
%patch1 -p1
%patch2 -p1
# hack to drop .abi3 from binaries (TODO: add support to python3.req/prov)
# see https://www.python.org/dev/peps/pep-3149/
%__subst "s|suffixes = importlib.machinery.EXTENSION_SUFFIXES|suffixes = ['.so']|" sipbuild/buildable.py
#__subst "s|name='sip'|name='sip6'|" setup.py
#find -type f | xargs subst "s|sipbuild|sipbuild6|g"
#mv -v sipbuild sipbuild6
rm -rv sip.egg-info/
# remove deps on distutils
rm -f sipbuild/distutils_builder.py

%build
%pyproject_build

%install
%pyproject_install
[ -d %buildroot/%python3_sitelibdir/sipbuild/module/source ] \
    || cp -ar sipbuild/module/source %buildroot/%python3_sitelibdir/sipbuild/module/

%files
%doc README* LICENSE*
%_bindir/sip-*
%python3_sitelibdir/sip-*.dist-info
%python3_sitelibdir/sipbuild/

%changelog
