%define _unpackaged_files_terminate_build 1
%define pypi_name sniffio
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 1.3.1
Release: alt1

Summary: Sniff out which async library your code is running under
License: MIT or Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/sniffio/
Vcs: https://github.com/python-trio/sniffio
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
This is a tiny package whose only purpose is to let you detect which async
library (like Trio, and asyncio, and ...) your code is running under.

%prep
%setup
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile test-requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- bash -s <<-'ENDUNITTEST'
set -eu
mkdir empty
cd empty
python -m pytest --pyargs %mod_name -ra
ENDUNITTEST

%files
%doc README.*
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/%pypi_name/_tests

%changelog
