%define oname sphinxtesters

%def_with check

Name: python3-module-%oname
Version: 0.2.3
Release: alt5

Summary: Utilities for testing Sphinx extensions

License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/sphinxtesters

BuildArch: noarch

# Source-url: %__pypi_url %oname
Source: %oname-%version.tar
Patch: sphinxtesters-0.2.3-configparser-alt-fix.patch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-docutils
BuildRequires: python3-module-sphinx
%endif

%description
Sphinxtesters - utilities for testing Sphinx extensions.

%prep
%setup -n %oname-%version
%patch -p2

%build
%pyproject_build

%install
%pyproject_install
%python3_prune

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test3 -vv -k 'not test_bad_pagebuilder'

%files
%doc LICENSE README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info


%changelog
