%define  oname spnego

%def_with check

Name:    python3-module-%oname
Version: 0.10.2
Release: alt1

Summary: Python SPNEGO authentication library

License: MIT
Group:   Development/Python3
URL:     https://pypi.org/project/pyspnego
VCS:     https://github.com/jborean93/pyspnego

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildArch: noarch

Source:  %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-cryptography
BuildRequires: python3-module-pytest-mock
%endif

# This is stuff for windows OS
# See more ALT#47264
%add_python3_req_skip spnego._sspi_raw.sspi

%description
Python SPNEGO Library to handle SPNEGO (Negotiate, NTLM, Kerberos)
authentication. Also includes a packet parser that can be used to
decode raw NTLM/SPNEGO/Kerberos tokens into a human readable format.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

# Hotfix for ALT#47250
# TypeError: main() missing 1 required positional argument: 'args'
sed -i 's/main()/main(sys.argv[1:])/' %buildroot%_bindir/pyspnego-parse

%check
%pyproject_run_pytest

%files
%doc LICENSE *.md
%_bindir/pyspnego-parse
%python3_sitelibdir/%oname
%python3_sitelibdir/py%oname-%version.dist-info

%changelog
