%global oname testpath

Name:           python3-module-%oname
Version:        0.6.0
Release:        alt2

Summary:        Test utilities for code working with files and commands

License:        MIT
Group:          Development/Python3
URL:            https://pypi.org/project/testpath

# https://github.com/jupyter/testpath
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(flit_core)

BuildRequires: python3(pytest) python3(pathlib2)
BuildRequires: python3-module-sphinx

BuildArch:      noarch

%description
Testpath is a collection of utilities for Python code working with files and
commands.

It contains functions to check things on the filesystem, and tools for
mocking system commands and recording calls to those.

%package        doc
Summary:        %name documentation
Group: Development/Documentation

%description doc
Documentation for %name.

%prep
%setup

# The exe files are not needed
rm -f %oname/*.exe

%build
%pyproject_build
# generate html docs
make SPHINXBUILD="sphinx-build-3" -C doc html

%install
%pyproject_install

%check
%__python3 -m pytest -v

%files
%doc README.rst LICENSE
%python3_sitelibdir/testpath/
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%files doc
%doc doc/_build/html

%changelog
