%define _unpackaged_files_terminate_build 1
%define pypi_name tinycss2

%def_with check

Name: python3-module-%pypi_name
Version: 1.3.0
Release: alt1

Summary: A tiny CSS parser
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/tinycss2/
VCS: https://github.com/Kozea/tinycss2.git

BuildArch: noarch

Source: %name-%version.tar
# submodule
# tests/css-parsing-tests from https://github.com/SimonSapin/css-parsing-tests
Source1: css-parsing-tests.tar
Source2: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
%pypi_name is a low-level CSS parser and generator written in Python: it can
parse strings, return objects representing tokens and blocks, and generate CSS
strings corresponding to these objects.

Based on the CSS Syntax Level 3 specification, %pypi_name knows the grammar of
CSS but doesn't know specific rules, properties or values supported in various
CSS modules.

%prep
%setup -a1
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra

%files
%doc README.rst docs/changelog.rst
%python3_sitelibdir/tinycss2/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
