%define _unpackaged_files_terminate_build 1
%define pypi_name tomlkit

%def_with check

Name: python3-module-%pypi_name
Version: 0.12.5
Release: alt1
Summary: Style preserving TOML library
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/tomlkit
VCS: https://github.com/sdispater/tomlkit.git
BuildArch: noarch
Source: %name-%version.tar
Source1: toml-test.tar
Source2: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter furo
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
TOML Kit is a 1.0.0-compliant TOML library. It includes a parser that preserves
all comments, indentations, whitespace and internal element ordering, and makes
them accessible and editable via an intuitive API. You can also create new TOML
documents from scratch using the provided helpers.

%prep
%setup -a1
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_poetry dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra tests

%files
%doc README.md
%python3_sitelibdir/tomlkit/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
