%define  oname traits

%def_without doc

%def_with check

Name:    python3-module-%oname
Version: 7.0.2
Release: alt1

Summary: Observable typed attributes for Python classes

License: BSD-3-Clause and CC-BY-3.0
Group:   Development/Python3
URL:     https://pypi.org/project/traits/
VCS:     https://github.com/enthought/traits

Source:  %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with doc
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-sphinx-pickles
BuildRequires: python3-module-sphinx-copybutton
%endif

%description
The traits package developed by Enthought provides a special type
definition called a trait. Although they can be used as normal Python object
attributes, traits also have several additional characteristics:

* Initialization: A trait can be assigned a default value.
* Validation: A trait attribute's type can be explicitly declared.
* Delegation: The value of a trait attribute can be contained either
  in another object.
* Notification: Setting the value of a trait attribute can trigger
  notification of other parts of the program.
* Visualization: User interfaces that permit the interactive
  modification of a trait's value can be automatically constructed
  using the trait's definition.

%package tests
Summary: Tests for Traits, explicitly typed attributes for Python 3
Group: Development/Python3
Requires: %name = %EVR

%description tests
The traits package developed by Enthought provides a special type
definition called a trait. This package contains tests for it.

%package doc
Summary: Documentation for Traits, explicitly typed attributes for Python
Group: Development/Documentation
BuildArch: noarch

%description doc
The traits package developed by Enthought provides a special type
definition called a trait. This package contains development
documentation for it.

%package pickles
Summary: Pickles for Traits, explicitly typed attributes for Python
Group: Development/Python3

%description pickles
The traits package developed by Enthought provides a special type
definition called a trait. This package contains pickles for it.

%prep
%setup

%if_with doc
%prepare_sphinx3 docs
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with doc
# pickles
install -d %buildroot%python3_sitelibdir/%oname
export PYTHONPATH=%buildroot%python3_sitelibdir
make -C docs html
%generate_pickles3 docs/source docs/source %oname
cp -fR pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
mkdir tester
pushd tester
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 -m unittest discover -v traits
popd

%files
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%doc README.rst LICENSE.txt LICENSE-CC-BY-3.0.txt
%exclude %python3_sitelibdir/%oname/tests
%if_with doc
%exclude %python3_sitelibdir/%oname/pickle
%endif

%files tests
%python3_sitelibdir/%oname/tests

%if_with doc
%files doc
%doc image_LICENSE*.txt LICENSE.txt LICENSE-CC-BY-3.0.txt
%doc examples
%doc docs/build/html

%files pickles
%python3_sitelibdir/%oname/pickle
%endif

%changelog
