%define _unpackaged_files_terminate_build 1
%define oname transaction

%def_with check

Name: python3-module-%oname
Version: 3.0.1
Release: alt2
Summary: Transaction management for Python
License: ZPL-2.1
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/transaction/

# https://github.com/zopefoundation/transaction.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# install_requires=
BuildRequires: python3(zope.interface)

BuildRequires: python3(mock)
BuildRequires: python3(zope.testrunner)

BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
%endif

%description
This package contains a generic transaction implementation for Python.
It is mainly used by the ZODB, though.

Note that the data manager API, transaction.interfaces.IDataManager, is
syntactically simple, but semantically complex. The semantics were not
easy to express in the interface. This could probably use more work. The
semantics are presented in detail through examples of a sample data
manager in transaction.tests.test_SampleDataManager.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version.dist-info/
%exclude %python3_sitelibdir/%oname/tests

%changelog
