%def_disable snapshot
%define pypi_name typogrify

%def_enable check

Name: python3-module-%pypi_name
Version: 2.1.0
Release: alt1

Summary: Filters to enhance web typography
Group: Development/Python3
License: BSD-3-Clause
Url: https://pypi.org/project/%pypi_name

Vcs: https://github.com/mintchaos/typogrify.git

%if_disabled snapshot
Source: https://pypi.io/packages/source/t/%pypi_name/%pypi_name-%version.tar.gz
%else
Source: %pypi_name-%version.tar
%endif

BuildArch: noarch

Requires: python3-module-smartypants >= 1.8.3

# Installing Jinja or Django is only required if you
# intend to use the optional template filters that are
# included for those frameworks.
%filter_from_requires /^python3(django/d
%filter_from_requires /^python3(jinja/d

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(wheel) python3(hatchling)
%{?_enable_check:BuildRequires: python3(smartypants) python3(pytest)
BuildRequires: python3(pytest_cov) python3(pytest_sugar)}

%description
Typogrify provides a set of custom filters that automatically apply
various transformations to plain text in order to yield
typographically-improved HTML. While often used in conjunction with Jinja
and Django template systems, the filters can be used in any environment.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
py.test-3 --doctest-modules typogrify/filters.py typogrify/packages/titlecase/tests.py

%files
%python3_sitelibdir_noarch/%pypi_name
%exclude %python3_sitelibdir_noarch/%pypi_name/packages/titlecase/tests.py
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc README*

%changelog
