%define _unpackaged_files_terminate_build 1
%define oname tzlocal

Name: python3-module-%oname
Version: 5.0.1
Release: alt1

Summary: A Python module that tries to figure out what your local timezone is

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/tzlocal/

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-pytz-deprecation-shim

%description
This Python module returns a tzinfo object (with a pytz_deprecation_shim,
for pytz compatibility) with the local timezone information, under
Unix and Windows.

It requires Python 3.6 or later, and will use the backports.tzinfo
package, for Python 3.6 to 3.8.

This module attempts to fix a glaring hole in the pytz and zoneinfo
modules, that there is no way to get the local timezone information,
unless you know the zoneinfo name, and under several Linux distros
that's hard or impossible to figure out.

With tzlocal you only need to call get_localzone() and you will get a
tzinfo object with the local time zone info. On some Unices you will
still not get to know what the timezone name is, but you don't need
that when you have the tzinfo file. However, if the timezone name is
readily available it will be used.

%prep
%setup

# fix symlink, required for test: https://github.com/regebro/tzlocal/issues/53
ln -sfv ../usr/share/zoneinfo/Africa/Harare \
   tests/test_data/symlink_localtime/etc/localtime

%build
%python3_build_debug

%install
%python3_install

%check
%__python3 -m pytest tests -v -k 'not test_conflicting and not test_noconflict'

%files
%doc CHANGES.txt LICENSE.txt README.rst
%python3_sitelibdir/*

%changelog
