%define oname zope.dublincore

%def_with check

Name: python3-module-%oname
Epoch: 1
Version: 5.0
Release: alt1.1

Summary: Zope Dublin Core implementation
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.dublincore
Vcs: https://github.com/zopefoundation/zope.dublincore

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-persistent
BuildRequires: python3-module-pytz
BuildRequires: python3-module-zope.annotation
BuildRequires: python3-module-zope.datetime
BuildRequires: python3-module-zope.lifecycleevent
BuildRequires: python3-module-zope.security
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.publisher
%endif

%description
zope.dublincore provides a Dublin Core support for Zope-based web
applications.

%package tests
Summary: Tests for zope.dublincore
Group: Development/Python3
Requires: %name = %EVR

%description tests
zope.dublincore provides a Dublin Core support for Zope-based web
applications.

This package contains tests for zope.dublincore.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -v

%files
%doc *.txt *.rst
%python3_sitelibdir/zope/dublincore
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/zope/dublincore/tests
%exclude %python3_sitelibdir/zope/dublincore/browser/tests

%files tests
%python3_sitelibdir/zope/dublincore/tests
%python3_sitelibdir/zope/dublincore/browser/tests


%changelog
