%define _unpackaged_files_terminate_build 1
%define oname zope.filerepresentation

%def_with check

Name: python3-module-%oname
Version: 6.1
Release: alt1.1

Summary: File-system Representation Interfaces
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.filerepresentation/
VCS: https://github.com/zopefoundation/zope.filerepresentation

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-zope.schema
BuildRequires: python3-module-zope.testrunner
%endif

%description
File-system representation interfaces.

The interfaces defined here are used for file-system and
file-system-like representations of objects, such as file-system
synchronization, FTP, PUT, and WebDAV.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
    %buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/zope/filerepresentation/
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/zope/filerepresentation/tests.py
%exclude %python3_sitelibdir/zope/filerepresentation/__pycache__/tests.*

%changelog
