%define _unpackaged_files_terminate_build 1
%define pypi_name zope.security
%define ns_name zope
%define mod_name security

%def_with check

Name: python3-module-%pypi_name
Version: 7.3
Release: alt1.1
Summary: Zope Security Framework
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.security/
Vcs: https://github.com/zopefoundation/zope.security
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# setuptools(pkg_resources) is used by namespace root that is packaged
# separately at python3-module-zope
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
# zope/proxy/proxy.h
BuildRequires: python3-module-zope.proxy-devel
%if_with check
%pyproject_builddeps_metadata_extra test
BuildRequires: python3-module-zope.component-tests
%endif

%description
The Security framework provides a generic mechanism to implement
security policies on Python objects.

%package tests
Summary: Tests for Zope Security Framework
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing

%description tests
The Security framework provides a generic mechanism to implement
security policies on Python objects.

This package contains tests for Zope Security Framework.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src

%files
%doc *.txt
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/examples/
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests/
%exclude %python3_sitelibdir/%ns_name/%mod_name/testing.py
%exclude %python3_sitelibdir/%ns_name/%mod_name/__pycache__/testing.*
%exclude %python3_sitelibdir/%ns_name/%mod_name/*.c

%files tests
%python3_sitelibdir/%ns_name/%mod_name/tests/
%python3_sitelibdir/%ns_name/%mod_name/testing.py
%python3_sitelibdir/%ns_name/%mod_name/__pycache__/testing.*

%changelog
