%define oname zope.server

%def_with check

Name: python3-module-%oname
Version: 4.0.2
Release: alt2
Summary: Zope Server (Web and FTP)
License: ZPLv2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.server/
#Git: https://github.com/zopefoundation/zope.server.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.publisher
BuildRequires: python3-module-paste
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-pyasyncore
%endif

%py3_requires zope zope.interface zope.publisher zope.security

%description
This package contains generic base classes for channel-based servers,
the servers themselves and helper objects, such as tasks and requests.

%package tests
Summary: Tests for zope.server
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing zope.i18n zope.component

%description tests
This package contains generic base classes for channel-based servers,
the servers themselves and helper objects, such as tasks and requests.

This package contains tests for zope.server.

%prep
%setup

sed -i 's/assertRaisesRegexp/assertRaisesRegex/' src/zope/server/ftp/tests/test_ftpserver.py

%build
%pyproject_build

%install
%pyproject_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/*/tests

%changelog
