%define oname zope.structuredtext

%def_with check

Name: python3-module-%oname
Version: 5.0
Release: alt2.1

Summary: StructuredText parser
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.structuredtext
Vcs: https://github.com/zopefoundation/zope.structuredtext

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-sphinx
%endif

%description
This package provides a parser and renderers for the classic Zope
"structured text" markup dialect (STX). STX is a plain text markup in
which document structure is signalled primarily by identation.

%package tests
Summary: Tests for StructuredText parser
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package provides a parser and renderers for the classic Zope
"structured text" markup dialect (STX). STX is a plain text markup in
which document structure is signalled primarily by identation.

This package contains tests for StructuredText parser.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
    %buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst docs/*.rst
%python3_sitelibdir/zope
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/examples*

%files tests
%python3_sitelibdir/*/*/tests.*
%python3_sitelibdir/*/*/*/examples*


%changelog
