
%define _unpackaged_files_terminate_build 1

Name: qgit
Version: 2.10
Release: alt1
Epoch: 1

Summary: Git GUI viewer built on Qt4/C++
Group: Development/Tools
License: GPLv2
Url: https://github.com/tibirna/qgit

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Provides: qgit4 = %EVR
Obsoletes: qgit4 < %EVR

BuildPreReq: gcc-c++ qt5-base-devel libXext-devel

%description
With qgit you will be able to browse revisions history, view
patch content and changed files, graphically following different
development branches.

Features:

* View revisions, diffs, files history, files annotation,
  archive tree.

* Commit changes visually cherry picking modified files.

* Apply or format patch series from selected commits, drag and
  drop commits between two instances of qgit.

* qgit implements a GUI for the most common StGIT commands like
  push/pop and apply/format patches. You can also create new
  patches or refresh current top one using the same semantics of
  git commit,  i.e. cherry picking single modified files.

%prep
%setup
%patch -p1
sed -i 's,debug_and_release,release,' qgit.pro
sed -i 's,debug_and_release,release,' src/src.pro
sed -i '/QMAKE_CXXFLAGS_RELEASE/s,-O2 ,%optflags ,g' src/src.pro

%build
qmake-qt5 qgit.pro
%make_build 

%install
install -pDm755 bin/qgit %buildroot%_bindir/%name

%files
%doc README.adoc
%_bindir/%name

%changelog
