%define qIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define qIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define qIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define qIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%define my_gcc_ver 5
%qIF_ver_gteq %ubt_id M90
%define my_gcc_ver %nil
%endif

%define binutils_ver %{get_version binutils}
%define _keep_libtool_files 1
#define _optlevel s
%def_enable bootstrap
%def_disable debug
%def_disable static_thread
%def_enable shared_thread
%def_enable docs
%def_enable sql_pgsql
%def_enable sql_odbc
%def_disable sql_sqlite2
%def_enable sql_ibase
%def_disable sql_tds
%def_enable gtkstyle
%def_enable glib
%def_enable versioning_hack

%define platform linux-g++
%define graphicssystem raster
%ifarch %arm
%define opengl_type es2
%else
%define opengl_type desktop
%endif

# Versions
%define rname	qt
%define major	4
%define minor	8
%define bugfix	7
%define beta	%nil
%define rlz alt26

Name: %rname%major
Version: %major.%minor.%bugfix
Release: %rlz

%define qtdir	%_libdir/%name
%add_findprov_lib_path	%qtdir/lib

Group: System/Libraries
Summary: Shared library for the Qt%major GUI toolkit
Url: http://qt-project.org/
License: LGPL-2.1-only or GPL-3.0-only

Requires: lib%name
Requires: %name-sql
Requires: %name-assistant
Requires: %name-dbus

Source0: qt-everywhere-opensource-src-%version%beta.tar
Source1: qt4-compat-map
Source2: qt4-compat-lds
Source3: rpmmacros
#
Source8: qtX-README.ALT
#
Source21: qt4-assistant.desktop
Source22: qt4-designer.desktop
Source23: qt4-linguist.desktop
Source24: qt4-qtconfig.desktop
Source25: qt4-qtdemo.desktop

Source101: %rname.16.png
Source102: %rname.32.png
Source103: %rname.48.png
Source104: %rname.64.png

# upstream
# security
# KDE-QT
Patch101: 0180-window-role.diff
Patch102: 0188-fix-moc-parser-same-name-header.diff
Patch103: 0191-listview-alternate-row-colors.diff
Patch104: 0195-compositing-properties.diff
Patch105: 0225-invalidate-tabbar-geometry-on-refresh.patch
# FC
Patch200: qt-aarch64.patch
Patch201: qt-everywhere-opensource-src-4.8.5-QTBUG-22829.patch
Patch202: qt-4.0.1-sans-mono.patch
Patch203: qt-everywhere-opensource-src-4.6.2-cups.patch
Patch204: qt-everywhere-opensource-src-4.6.3-glib_eventloop_nullcheck.patch
Patch205: qt-x11-opensource-src-4.5.1-enable_ft_lcdfilter.patch
Patch206: qt-everywhere-opensource-src-4.8.3-qdbusconnection_no_debug.patch
Patch207: qt-everywhere-opensource-src-4.8.1-icu_no_debug.patch
Patch208: qt-everywhere-opensource-src-4.8.6-systemtrayicon.patch
Patch209: qt-everywhere-opensource-src-4.8.5-QTBUG-21900.patch
Patch210: qt-everywhere-opensource-src-4.8.0-QTBUG-22037.patch
Patch211: qt-everywhere-opensource-src-4.8.2--assistant-crash.patch
Patch212: qt-everywhere-opensource-src-4.8.0-tp-qtreeview-kpackagekit-crash.patch
Patch213: qt-everywhere-opensource-src-4.8.3-no_Werror.patch
Patch214: qt-everywhere-opensource-src-4.8.5-QTBUG-4862.patch
Patch215: qt-everywhere-opensource-src-4.8.5-qt_plugin_path.patch
Patch216: qt-everywhere-opensource-src-4.8.6-QTBUG-34614.patch
Patch217: qt-everywhere-opensource-src-4.8.5-QTBUG-35459.patch
Patch218: qt-everywhere-opensource-src-4.8.7-alsa-1.1.patch
Patch219: qt-everywhere-opensource-src-4.8.7-gcc6.patch
# Debian
Patch301: CVE-2018-15518.patch
Patch302: CVE-2018-19869.patch
Patch303: CVE-2018-19870.patch
Patch304: CVE-2018-19871.patch
Patch305: CVE-2018-19872.patch
Patch306: CVE-2018-19873.patch
Patch307: CVE-2020-17507.patch
#
Patch320: gcc9-qforeach.patch
Patch321: Add_support_for_QT_USE_DRAG_DISTANCE_env_var.patch
Patch322: Better-handling-of-invalid-font-tables.patch
Patch323: dont_crash_on_broken_gif_images.patch
Patch324: xmlpatterns_stack_overflow_fix.diff
Patch325: qtdoc-build-offline-docs.patch
# Arch
Patch340: qt4-gcc11.patch
# ALT
Patch501: qt-4.8.5-alt-honor-SUSv3-locales.patch
Patch502: qt-4.7.2-alt-ca-certificates-path.patch
Patch503: qt-4.7.3-alt-qt-config-add-webkit.patch
Patch504: qt-4.7.0-alt-fix-gl-loading.patch
Patch505: qt-4.0.1-alt-iso_c_extension.patch
Patch506: qt-4.8.7-alt-kde-breeze.patch
Patch507: qt-4.8.6-alt-disable-gstreamer.patch
Patch508: qt-4.7.4-alt-buildkey.patch
Patch509: qt-4.7.0-alt-qtconfig_add_translator.patch
Patch510: qt-4.8.0-alt-ldflags.patch
Patch511: qt-4.3.2-alt-checkbox-indicator-plastique.patch
Patch512: qt-4.3.4-alt-uitools-shared.patch
Patch513: qt-4.8.6-alt-fix-ssl-loading.patch
Patch514: qt-4.8.5-alt-fix-resolv-loading.patch
Patch515: qt-4.6.1-alt-xmlpatterns-fexceptions.patch
Patch516: qt-4.7.1-alt-sql-ibase-firebird.patch
Patch517: alt-sql-mysql.patch
# SuSE
Patch701: handle-tga-files-properly.diff
Patch702: build-qvfb-tool.diff
Patch703: libqt4-libtool-nodate.diff
Patch704: qfatal-noreturn.diff
Patch705: fix-build-icu59.patch
#
Patch706: qt-never-strip.diff
Patch707: rcc-stable-dirlisting.diff
Patch708: no-ssl3.patch
Patch709: qt4-openssl-1.1.0pre-3.patch
Patch710: qt-everywhere-opensource-src-4.8.7-openssl.patch
# fixes for LibreOffice-kde QTBUG 37380,34614,38585
Patch800: glib-honor-ExcludeSocketNotifiers-flag.diff
Patch801: l-qclipboard_delay.patch
# Sergey A. Sukiyazov <sergey.sukiyazov NEAR gmail.com>
Patch9100: 9100-qt-core-fix-iconvcodec.patch
#
Patch9102: 9102-qt-gui-menubar_activate.patch
Patch9103: 9103-qt-gui-fix_shortcuts.patch
Patch9104: 9104-qt-gui-fix_loss_mouse_button_release_event.patch
Patch9105: 9105-qt-qt3support-menubar_activate.patch
Patch9106: 9107-qt-webkit-fix_graphicscontextqt.patch


# Automatically added by buildreq on Thu Apr 07 2011 (-bi)
# optimized out: alternatives elfutils fontconfig fontconfig-devel glib2-devel gstreamer-devel libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXcursor-devel libXext-devel libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel libXrender-devel libXv-devel libatk-devel libcairo-devel libcom_err-devel libdbus-devel libfreetype-devel libgdk-pixbuf-devel libgio-devel libgst-plugins libkrb5-devel libpango-devel libpng-devel libpq-devel libqt4-devel libqt4-sql-sqlite libssl-devel libstdc++-devel libtiff-devel libunixODBC-devel libxml2-devel pkg-config python-base ruby xorg-fixesproto-devel xorg-inputproto-devel xorg-kbproto-devel xorg-randrproto-devel xorg-renderproto-devel xorg-videoproto-devel xorg-xextproto-devel xorg-xproto-devel zlib-devel
#BuildRequires: firebird-devel gcc-c++ glibc-devel-static gst-plugins-devel libalsa-devel libcups-devel libfreetds-devel libgtk+2-devel libjpeg-devel libmng-devel libmysqlclient-devel libpulseaudio-devel libqt4-sql-interbase libqt4-sql-mysql libqt4-sql-odbc libqt4-sql-postgresql libqt4-sql-sqlite2 libsqlite-devel libsqlite3-devel makedepend phonon-devel postgresql-devel rpm-build-ruby
%if "%my_gcc_ver" == "%nil"
BuildRequires: gcc-c++
%else
%set_gcc_version %my_gcc_ver
BuildRequires: gcc%{my_gcc_ver}-c++
%endif
BuildRequires(pre): rpm-build-ubt
BuildRequires: libfreetype-devel pkg-config rpm-utils rpm-macros-alternatives browser-plugins-npapi-devel
BuildRequires: libcups-devel libalsa-devel
BuildRequires: libstdc++-devel libcom_err-devel libicu-devel libffi-devel
BuildRequires: libjpeg-devel libmng-devel libpng-devel zlib-devel libtiff-devel
BuildRequires: libxml2-devel libxslt-devel libreadline-devel libpam0-devel
BuildRequires: libmysqlclient-devel libsqlite3-devel
BuildRequires: bison pkg-config
BuildRequires: fontconfig-devel libssl-devel libkrb5-devel libdbus-devel
BuildRequires: libatk-devel libcairo-devel libgdk-pixbuf-devel libgio-devel libpango-devel
BuildRequires: libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXcursor-devel libXext-devel
%if "%opengl_type" == "es2" || "%opengl_type" == "es1"
BuildRequires: libGLES-devel
%endif
BuildRequires: libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel libXrender-devel libXv-devel
BuildRequires: xorg-proto-devel libXtst-devel
%{?_enable_sql_tds:BuildRequires: libfreetds-devel}
%{?_enable_sql_pgsql:BuildRequires: postgresql-devel}
%{?_enable_sql_ibase:BuildRequires: firebird-devel}
%{?_enable_gtkstyle:BuildRequires: libgtk+2-devel}
%{?_enable_glib:BuildRequires: glib2-devel}
%{?_enable_sql_sqlite2:BuildRequires: libsqlite-devel}
%{?_enable_sql_odbc:BuildRequires: libunixODBC-devel}


%description
Qt is a GUI software toolkit. Qt simplifies the task of writing and maintaining
GUI (graphical user interface) applications for the X Windows system.
It has everything you need to create professional GUI applications.
And it enables you to create them quickly.
Qt is multi-platform toolkit written in C++ and is fully object-oriented.
This package contains the shared library needed to run Qt%major applications, as
well as the README files for Qt.

##############################################
%package common
Summary: Common package for Qt%major
Group: System/Libraries
Requires: common-licenses
%description common
Common package for Qt%major

##############################################
%package -n lib%name
BuildArch: noarch
Summary: Shared library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: lib%name-core
Requires: lib%name-gui
Requires: lib%name-network
Requires: lib%name-opengl
Requires: lib%name-sql
Requires: lib%name-xml
Requires: lib%name-qt3support
Requires: lib%name-svg
Requires: lib%name-script
Requires: lib%name-designer
Requires: lib%name-uitools
Requires: lib%name-xmlpatterns
Requires: lib%name-multimedia
Requires: lib%name-help
Requires: lib%name-declarative
Requires: lib%name-clucene
Requires: lib%name-dbus
Provides: lib%name-x11 = %version-%release
Provides: %name-x11 = %version-%release
Provides: qt-x11 = %version-%release
Provides: qt = %version-%release

%description -n lib%name
Qt is a GUI software toolkit. Qt simplifies the task of writing and maintaining
GUI (graphical user interface) applications for X Windows System.
Qt is written in C++ and is fully object-oriented. It has everything you need
to create professional GUI applications. And it enables you to create them
quickly.

Qt is a multi-platform toolkit. When developing software with Qt, you can run
it on the X Window System (Unix/X11) or Microsoft Windows NT and Windows 95/98
or framebuffer devices.
Simply recompile your source code on the platform you want.

This package contains the shared library needed to run Qt%major applications, as
well as the README files for Qt.

##############################################
%package -n lib%{name}-qt3support
Summary: Qt3 support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-qt3support
Qt3 support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-core
Summary: Core library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
Requires: glibc-gconv-modules
%description -n lib%{name}-core
Core library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-gui
Summary: GUI support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
Provides: libqtgui%major = %version-%release
Conflicts: yachat < 3.1.0 yapsi < 3.1.0
%description -n lib%{name}-gui
GUI support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-dbus
Summary: DBus support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-dbus
DBus support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-network
Summary: Network support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-network
Network support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-uitools
Summary: Designer UI tools library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-uitools
Designer UI tools library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-svg
Summary: SVG support for the Qt%major GUI toolkit
Group: System/Libraries
%description -n lib%{name}-svg
Support for rendering Scalable Vector Graphics (SVG)
drawings and animations for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-opengl
Summary: OpenGL support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-opengl
OpenGL support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-sql
Summary: SQL support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-sql
SQL support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-test
Summary: Unit Testing Library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-test
Unit Testing Library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-designer
Summary: Libraries for the Qt%major Designer
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-designer
Libraries for the Qt%major Designer

##############################################
%package -n lib%{name}-xml
Summary: XML support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-xml
XML support library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-script
Summary: Scripting support library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-script
Qt Script is based on the ECMAScript scripting language, as defined in
standard ECMA-262. Microsoft's JScript, and Netscape's JavaScript are
also based on the ECMAScript standard.

##############################################
%package -n lib%{name}-xmlpatterns
Summary: XmlPatterns library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-xmlpatterns
XmlPatterns library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-scripttools
Summary: ScriptTools library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-scripttools
ScriptTools library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-help
Summary: Help library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-help
Help library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-clucene
Summary: CLucene library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-clucene
CLucene library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-multimedia
Summary: Multimedia framework library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-multimedia
Multimedia framework library for the Qt%major GUI toolkit

##############################################
%package -n lib%{name}-declarative
Summary: Ddeclarative framework library for the Qt%major GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%{name}-declarative
Declarative framework library for the Qt%major GUI toolkit
Declarative module provides a declarative framework
for building highly dynamic, custom user interfaces

##############################################
%package devel
BuildArch: noarch
Group: System/Libraries
Summary: Meta-package for development with Qt%major GUI toolkit
Requires: lib%name-devel
Requires: %name-designer
Requires: %name-assistant
Requires: %name-qvfb
%if_enabled docs
Requires: %name-doc
%endif
%description devel
Meta-package for development with Qt%major GUI toolkit

##############################################
%package -n lib%name-devel
Summary: Header files and libraries for developing apps which will use Qt%major
Group: Development/KDE and QT
Requires: libssl-devel freetype2-devel fontconfig-devel libpng-devel zlib-devel
Requires: libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXcursor-devel libXext-devel
Requires: libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel libXrender-devel libXv-devel
Requires: xorg-proto-devel libXtst-devel
Requires: libdbus-devel
%if_disabled bootstrap
Requires: phonon-devel
Requires: libqt4-webkit-devel
%endif
# for qcollectiongenerator
Requires: lib%name-sql-sqlite
Requires: rpm-macros-%{name} = %{version}-%{release}
Provides: lib%name-devel-cxx = %__gcc_version_base
%description -n lib%name-devel
Qt is a GUI software toolkit. Qt simplifies the task of writing and maintaining
GUI (graphical user interface) applications for X Windows.

Qt is written in C++ and is fully object-oriented. It has everything you need
to create professional GUI applications. And it enables you to create them
quickly.

Qt is a multi-platform toolkit. When developing software with Qt, you can run
it on the X Window System (Unix/X11) or Microsoft Windows NT and Windows 95/98.
Simply recompile your source code on the platform you want.

This package contains the files necessary to develop applications

##############################################
%package -n lib%name-devel-static
Summary: Version of the Qt GUI toolkit for static linking
Group: Development/KDE and QT
Requires: lib%name-devel
Obsoletes: %name-devel-static
%description -n lib%name-devel-static
This package package contains the files necessary to link applications
to the Qt GUI toolkit statically (rather than dynamically).
Statically linked applications don't require the library to be installed
on the system running the application.

##############################################
%package qml
Summary: QML modules Qt%major
Group: Development/KDE and QT
Requires: lib%name-devel
%description qml
The package contains a QML modules and viewer for the Qt%major toolkit.

##############################################
%package designer
Summary: Designer for the Qt%major
Group: Development/KDE and QT
Requires: lib%name-devel
%description designer
The package contains an User Interface designer
tool for the Qt%major toolkit.

##############################################
%package -n lib%name-styles
Summary: Extra styles for the Qt GUI toolkit
Group: System/Libraries
Requires: %name-common
%description -n lib%name-styles
Extra styles (themes) for the Qt GUI toolkit.

##############################################
%package sql
BuildArch: noarch
Group: System/Libraries
Summary: Meta-package for SQL support of Qt%major GUI toolkit
Requires: lib%name-sql-mysql
Requires: lib%name-sql-sqlite
%if_enabled sql_tds
Requires: lib%name-sql-tds
%endif
%if_enabled sql_ibase
Requires: lib%name-sql-interbase
%endif
%if_enabled sql_pgsql
Requires: lib%name-sql-postgresql
%endif
%if_enabled sql_ibase
Requires: lib%name-sql-interbase
%endif
%if_enabled sql_sqlite2
Requires: lib%name-sql-sqlite2
%endif
%if_enabled sql_odbc
Requires: lib%name-sql-odbc
%endif
%if_enabled sql_tds
Requires: lib%name-sql-tds
%endif
%description sql
Meta-package for SQL support of Qt%major GUI toolkit

##############################################
%package -n lib%name-sql-odbc
Summary: ODBC drivers for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-odbc
ODBC driver for Qt's SQL classes (QODBC)

##############################################
%package -n lib%name-sql-tds
Summary: FreeTDS(Sybase) driver for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-tds
FreeTDS(Sybase) driver for Qt's SQL classes (QTDS)

##############################################
%package -n lib%name-sql-mysql
Summary: MySQL driver for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-mysql
MySQL driver for Qt's SQL classes (QMYSQL)

##############################################
%package -n lib%name-sql-postgresql
Summary: PostgreSQL drivers for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-postgresql
PostgreSQL driver for Qt's SQL classes (QPSQL)

##############################################
%package -n lib%name-sql-interbase
Summary: InterBase drivers for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-interbase
InterBase driver for Qt's SQL classes (QIBASE)

##############################################
%package -n lib%name-sql-sqlite
Summary: SQLite driver for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-sqlite
SQLite driver for Qt's SQL classes (QSQLITE)

##############################################
%package -n lib%name-sql-sqlite2
Summary: SQLite2 driver for Qt%major SQL classes
Group: System/Libraries
Provides: lib%name-plugin-sql = %version-%release
%description -n lib%name-sql-sqlite2
SQLite2 driver for Qt's SQL classes (QSQLITE2)

##############################################
%package doc
BuildArch: noarch
Summary: Document for developing apps which will use Qt%{major}
Group: Development/KDE and QT
Requires: %name-common = %version
Requires: %name-assistant = %version
Requires: %name-doc-html = %version
#Requires: %name-doc-man = %version
Requires: %name-doc-examples = %version
%description doc
This package contains documentation and sources for example programs.

##############################################
%package doc-html
BuildArch: noarch
Summary: Document for developing apps which will use Qt%{major}
Group: Development/KDE and QT
Requires: %name-common = %version
%description doc-html
This package contains documentation in html format.

##############################################
%package doc-man
BuildArch: noarch
Summary: Document for developing apps which will use Qt%{major}
Group: Development/KDE and QT
Requires: %name-common = %version
%description doc-man
This package contains documentation in man format.

##############################################
%package doc-examples
BuildArch: noarch
Summary: Examples for developing apps which will use Qt%{major}
Group: Development/KDE and QT
Requires: %name-common
Requires: %name-doc-examples-src
Requires: %name-doc-examples-bin
%description doc-examples
This package contains example programs.

##############################################
%package doc-examples-src
#BuildArch: noarch
Summary: Examples sources for developing apps which will use Qt%{major}
Group: Development/KDE and QT
Requires: %name-common
%description doc-examples-src
This package contains sources of example programs.

##############################################
%package doc-examples-bin
Summary: Examples binaries for developing apps which will use Qt%{major}
Group: Development/KDE and QT
Requires: %name-common
Requires: %name-doc-examples-src
%description doc-examples-bin
This package contains binaries of example programs.

##############################################
%package assistant
Summary: Assistant for the Qt%major
Group: Text tools
Requires: %name-common
Requires: lib%name-sql-sqlite
%description assistant
This package contains an documentation browser
for the Qt%major toolkit and Qt-based programs.

##############################################
%package qvfb
Summary: Virtual frame buffer for Qt for Embedded Linux
Group: Emulators
Requires: %name-common
%description qvfb
Virtual frame buffer for Qt for Embedded Linux

##############################################
%package dbus
Summary: D-Bus utilities for the Qt%major
Group: System/Configuration/Other
Requires: %name-common
Requires: dbus-tools-gui
%description dbus
This package contains D-Bus utilities
for the Qt%major toolkit and Qt-based programs.

##############################################
%package -n rpm-macros-%{name}
Version: %major.%minor.%bugfix
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/KDE and QT
BuildArch: noarch
Requires: %name-common
%description -n rpm-macros-%{name}
Set of RPM macros for packaging %name-based applications for %distribution
Install this package if you want to create RPM packages that use %name

##############################################
%package -n rpm-build-%{name}
Version: %major.%minor.%bugfix
Summary: Set of RPM-related scripts for packaging %name-based applications
Group: Development/KDE and QT
Requires: %name-common
%description -n rpm-build-%{name}
Set of RPM-related scripts for packaging %name-based applications for %distribution
Install this package if you want to create RPM packages that use %name

##############################################
%prep
%define buildsubdir qt-everywhere-opensource-src-%version%beta

%setup -q -n %buildsubdir
# upstream
# security
# KDE-QT
#%patch101 -p0
%patch102 -p0
%patch103 -p0
%patch104 -p0
%patch105 -p0
# FC
%patch200 -p1
%patch201 -p1
%patch202 -p1
%patch203 -p1
%patch204 -p1
%patch205 -p1
%patch206 -p1
%patch207 -p1
%patch208 -p1
%patch209 -p1
%patch210 -p1
%patch211 -p1
%patch212 -p1
%patch213 -p1
%patch214 -p1
%patch215 -p1
%patch216 -p0
%patch217 -p1
%patch218 -p1
%patch219 -p1
# Debian
%patch301 -p1
%patch302 -p1
%patch303 -p1
%patch304 -p1
%patch305 -p1
%patch306 -p1
%patch307 -p1
#
%patch320 -p1
%patch321 -p1
%patch322 -p1
%patch323 -p1
%patch324 -p1
%patch325 -p1
# Arch
%patch340 -p0
# ALT
%patch501 -p1
%patch502 -p1
%patch503 -p1
%patch504 -p1
%patch505 -p1
%patch506 -p1
%patch507 -p1
%patch508 -p1
###%patch509 -p1
%patch510 -p1
%patch511 -p1
%patch512 -p1
%patch513 -p1
%patch514 -p1
%patch515 -p1
%patch516 -p1
%patch517 -p1

%patch701 -p0
%patch702 -p0
%patch703 -p0
%patch704 -p0
%patch705 -p1
#
%patch706 -p0
%patch707 -p1
%patch708 -p1
%patch709 -p1
%patch710 -p1

%patch800 -p1
%patch801 -p0

%patch9100 -p1
#
%patch9102 -p1
%patch9103 -p1
%patch9104 -p1
%patch9105 -p1

sed -i "s|-O2||" mkspecs/*/qmake.conf
sed -i "s|-O2||" mkspecs/common/g++.conf
%if_enabled debug
sed -i "s|^CFG_DEBUG=.*|CFG_DEBUG=yes|" ./configure
%else
sed -i "s|^CFG_DEBUG=.*|CFG_DEBUG=no|" ./configure
%endif
sed -i /meego/d src/plugins/graphicssystems/graphicssystems.pro

%build
%define optflags_lto %nil
%add_optflags -std=gnu++98 -fpermissive -Wno-deprecated -DOPENSSL_LOAD_CONF -DOPENSSL_NO_SSL2
# install %%optflags
subst "s|^\s*QMAKE_CFLAGS\s*=.*$|QMAKE_CFLAGS = %optflags -DGLX_GLXEXT_LEGACY|" mkspecs/*/qmake.conf
subst "s|^\s*QMAKE_CFLAGS\s*=.*$|QMAKE_CFLAGS = %optflags -DGLX_GLXEXT_LEGACY|" mkspecs/common/g++.conf

# don't strip binaries during install
subst "s|^QMAKE_STRIP.*=.*|QMAKE_STRIP =|" mkspecs/common/linux.conf

# versioning hack
grep -q "^\s*QMAKE_LFLAGS_SONAME\s*\+" src/corelib/corelib.pro \
    || echo "QMAKE_LFLAGS_SONAME += " >> src/corelib/corelib.pro
%if_enabled versioning_hack
sed -i 's|^\s*QMAKE_LFLAGS_SONAME\s*\+.*$|QMAKE_LFLAGS_SONAME += -Wl,--version-script=%_sourcedir/qt4-compat-map -Wl,%_sourcedir/qt4-compat-lds|' src/corelib/corelib.pro
%else
sed -i 's|^\s*QMAKE_LFLAGS_SONAME\s*\+.*$|QMAKE_LFLAGS_SONAME += |' src/corelib/corelib.pro
%endif

export QT_DIR="$PWD"
export PATH=$QT_DIR/bin:$PATH
export LD_LIBRARY_PATH=$QT_DIR/lib:$LD_LIBRARY_PATH
export QT_PLUGIN_PATH=$QT_DIR/plugins
export CFLAGS="%optflags" CXXFLAGS="%optflags"

CNFGR="\
	-I%_includedir/pgsql/ -I%_includedir/mysql/ \
	-I/usr/include/fontconfig \
        -prefix %qtdir \
	-bindir %qtdir/bin \
	-docdir %_docdir/%name \
	-headerdir %_includedir/%name \
	-libdir %_libdir \
	-translationdir %_datadir/%name/translations \
	-plugindir %qtdir/plugins \
	-importdir %qtdir/imports \
	-sysconfdir %_sysconfdir/xdg \
	-datadir %_datadir/%name \
	-examplesdir %_datadir/%name/examples \
	-demosdir %_datadir/%name/demos \
	\
	-platform %platform \
	%{?_enable_debug:-debug}%{!?_enable_debug:-release} -verbose -no-separate-debug-info \
	-largefile -stl -fast -no-rpath -no-exceptions -no-g++-exceptions -accessibility -no-pch -icu \
	\
	-graphicssystem %graphicssystem -opengl %opengl_type \
	-system-zlib -cups -openssl-linked \
	-no-webkit \
	-xmlpatterns -scripttools \
	-multimedia -declarative \
	-no-nas-sound -no-nis -iconv \
	-no-phonon -no-gstreamer \
	%{?_enable_gtkstyle: -gtkstyle}%{!?_enable_gtkstyle: -no-gtkstyle} \
	%{?_enable_glib: -glib}%{!?_enable_glib: -no-glib} \
	\
	-dbus-linked \
	\
	-sm -mitshm -fontconfig -xfixes -xshape -xcursor -xinerama -xrender -xrandr -xkb -xinput -xsync \
	\
	-svg \
	-system-libpng -system-libjpeg -system-libmng -system-libtiff"
#	-DQT_USE_APPROXIMATE_CURSORS \
#	-xvideo \

CNFGR_STATIC=" -static \
	-qt-sql-mysql -qt-sql-sqlite -system-sqlite \
	%{?_enable_sql_tds:-qt-sql-tds} \
	%{?_enable_sql_ibase:-qt-sql-ibase} \
	%{?_enable_sql_pgsql:-qt-sql-psql} \
	%{?_enable_sql_sqlite2:-qt-sql-sqlite2} \
	%{?_enable_sql_odbc:-qt-sql-odbc}"

CNFGR_SHARED=" -shared \
	-plugin-sql-mysql -plugin-sql-sqlite -system-sqlite \
	%{?_enable_sql_tds:-plugin-sql-tds} \
	%{?_enable_sql_ibase:-plugin-sql-ibase} \
	%{?_enable_sql_pgsql:-plugin-sql-psql} \
	%{?_enable_sql_sqlite2:-plugin-sql-sqlite2} \
	%{?_enable_sql_odbc:-plugin-sql-odbc}"

is_building=""
clean_but_lib()
{
    [ -n "$is_building" ] || return
    mkdir -p lib-built
    cp -ar lib/* lib-built
    make confclean
    rm -rf lib/*
}

# Build   STATIC THREADED   libraries #
%if_enabled static_thread
if ! [ -e lib/libQtCore.a ] ; then
echo -e "o\nyes" |./configure $CNFGR_STATIC $CNFGR -nomake examples -nomake demos -nomake tests -nomake docs -nomake translations
%make_build -C src
%make_build -C tools/designer/src/uitools
is_building=1
clean_but_lib
fi
%endif #static_thread

# Build   SHARED THREADED   libraries #
%if_enabled shared_thread
if ! [ -e lib/libQtCore.so ] ; then
echo -e "o\nyes" |./configure $CNFGR_SHARED $CNFGR %{!?_enable_docs:-nomake examples -nomake demos -nomake tests -nomake docs}
%make_build
fi
%if_enabled sql_sqlite2
%make_build -C src/plugins/sqldrivers/sqlite2
%endif
%if_enabled docs
[ -d doc-build ] || %make_build docs
%endif
%endif #shared_thread

# compile translations
LD_LIBRARY_PATH=./lib ./bin/lrelease ./translations/*.ts
rm -f ./translations/*_untranslated.qm


%install
%if_enabled debug
%set_strip_method none
%endif

export QTDIR=%qtdir
export QT_DIR="$PWD"
export PATH=$QT_DIR/bin:%buildroot/%qtdir/bin:$PATH
export MANPATH=%qtdir/doc/man:$MANPATH
export LD_LIBRARY_PATH=$QT_DIR/lib:$LD_LIBRARY_PATH

install -d -m 0755 %buildroot/%_bindir
install -d -m 0755 %buildroot/%qtdir/plugins/codecs/
install -d -m 0755 %buildroot/%qtdir/plugins/crypto/
install -d -m 0755 %buildroot/%qtdir/plugins/accessible/
install -d -m 0755 %buildroot/%qtdir/plugins/styles/
install -d -m 0755 %buildroot/%qtdir/imports/QtWebKit

%make INSTALL_ROOT=%buildroot install
[ -x %buildroot/%qtdir/bin/qdoc3 ] \
    || install -m 0755 bin/qdoc3 %buildroot/%qtdir/bin/
%if_enabled sql_sqlite2
%make INSTALL_ROOT=%buildroot install -C src/plugins/sqldrivers/sqlite2
%endif


%if_enabled docs
# apply docs
mkdir -p %buildroot/%_docdir/
ln -s `relative %_docdir/%name %_datadir/%name/doc` %buildroot/%_datadir/%name/doc
%endif
ln -s `relative %_docdir/%name %qtdir/doc` %buildroot/%qtdir/doc

# install rpm macros
install -d -m 0755 %buildroot/%_rpmmacrosdir/
install -m 0644 %SOURCE3 %buildroot/%_rpmmacrosdir/%name

# install settings directory
install -d -m 0755 %buildroot/%_sysconfdir/xdg/
ln -s ../../../%_sysconfdir/xdg %buildroot/%qtdir/settings

# install tools
install -m 775 bin/findtr %buildroot/%qtdir/bin/
pushd %buildroot/%qtdir/bin/
for f in `ls -1`; do
    ln -s ../..%qtdir/bin/$f %buildroot/%_bindir/$f-%name
done
popd

# install libraries
#
mkdir -p %buildroot/%qtdir/lib
pushd %buildroot/%_libdir
for f in lib*.so.*; do
    ln -s ../../$f %buildroot/%qtdir/lib/
    [ -f $f ] \
	&& ln -sf $f %buildroot/%qtdir/lib/`echo $f| sed "s|\(.*\.so\).*|\1|"`
done
popd
%if_enabled static_thread
for f in lib-built/lib*.a lib-built/lib*.la; do
install -m0644 $f %buildroot/%qtdir/lib/
done
%endif
#
ln -s %name %buildroot/%_libdir/%rname-%version

# clean from WebKit
rm -f %buildroot/%qtdir/imports/QtWebKit/*
rm -f %buildroot/%_libdir/libQtWebKit.*
rm -f %buildroot/%qtdir/lib/libQtWebKit.*
rm -f %buildroot/%_includedir/%name/QtWebKit/*
rm -f %buildroot/%_pkgconfigdir/QtWebKit.pc

# install qdbus alternative
QDBUS_ALTPRIO=`printf '%%.2d%%.2d%%.2d%%.2d\n' 0 %major %minor %bugfix`
mkdir -p %buildroot/%_altdir/
cat > %buildroot/%_altdir/qdbus-%name <<__EOF__
%_bindir/qdbus %qtdir/bin/qdbus $QDBUS_ALTPRIO
__EOF__
cat > %buildroot/%_altdir/qdbusviewer-%name <<__EOF__
%_bindir/qdbusviewer %qtdir/bin/qdbusviewer $QDBUS_ALTPRIO
__EOF__
mkdir -p %buildroot/usr/lib/kde4/bin/
ln -s `relative %qtdir/bin/qdbus /usr/lib/kde4/bin/qdbus` %buildroot/usr/lib/kde4/bin/qdbus

# install translations
#install -m 644 ./translations/*.qm %buildroot/%qtdir/translations
mkdir -p %buildroot/%_datadir/%name/translations
ln -s ../../../%_datadir/%name/translations %buildroot/%qtdir/translations
mkdir -p %buildroot/%_datadir/%name/phrasebooks
ln -s ../../../%_datadir/%name/phrasebooks %buildroot/%qtdir/phrasebooks
# findlang
rm -f *.lang
for f in %buildroot/%_datadir/%name/translations/*.qm
do
    APP=`echo "$f"| sed -e 's|^.*/\(.*\)_\([a-z][a-z]\)[^[:alpha:]].*|\1|'`
    LNG=`echo "$f"| sed -e 's|^.*/\(.*\)_\([a-z][a-z]\)[^[:alpha:]].*|\2|'`
    FILE=%%_datadir/%name/translations/`basename "$f"`
    if ! [ -f $APP.lang ]; then
	echo "%%defattr(644,root,root,755)" > $APP.lang
    fi
    echo "%%lang($LNG) $FILE" >>$APP.lang
done
cat linguist.lang >> designer.lang

# install pkgconfig files
#mkdir -p %buildroot/%_libdir/pkgconfig
#for f in %buildroot/%_libdir/*.pc; do
#    mv $f %buildroot/%_libdir/pkgconfig/
#done
sed -i "s|\(-L\${libdir}\)|-L%qtdir/lib \1|" %buildroot/%_libdir/pkgconfig/*.pc

# install includes
mkdir -p %buildroot/%_includedir/
ln -s ../../../%_includedir/%name %buildroot/%qtdir/include

# install designer templates
#install -d -m 0755 %buildroot/%qtdir/tools/designer/templates
#cp -fR tools/designer/templates/*.ui %buildroot/%qtdir/tools/designer/templates

# Ship qmake stuff
ln -s ../../../%_datadir/%name/mkspecs %buildroot/%qtdir/mkspecs
# uninstall optflags
subst "s|^\s*QMAKE_CFLAGS\s*=.*$|QMAKE_CFLAGS	= -pipe|" %buildroot/%qtdir/mkspecs/*/qmake.conf
subst "s|^\s*QMAKE_CFLAGS\s*=.*$|QMAKE_CFLAGS	= -pipe|" %buildroot/%qtdir/mkspecs/common/g++.conf
# fix lib*.so placement
subst "s|^\s*QMAKE_LIBDIR_QT\s*=.*$|QMAKE_LIBDIR_QT		= %qtdir/lib|" %buildroot/%qtdir/mkspecs/*/qmake.conf
subst "s|^\s*QMAKE_LIBDIR_QT\s*=.*$|QMAKE_LIBDIR_QT		= %qtdir/lib|" %buildroot/%qtdir/mkspecs/common/g++.conf
%if_enabled versioning_hack
## fix QMAKE_LFLAGS_SONAME
#for f in %buildroot/%_datadir/%name/mkspecs/*/qmake.conf
#do
#    subst "s|^.*QMAKE_LFLAGS_SONAME.*$|QMAKE_LFLAGS_SONAME     = -Wl,-soname,|g" $f
#done
%endif


# install documentation
#install -d -m 0755 %buildroot/%_docdir/%name/doc/html
#install -m 0644 doc/html/*.html %buildroot/%_docdir/%name/doc/html
install -d -m 0755 %buildroot/%_docdir/%name/
cat > %buildroot/%_docdir/%name/LICENSE.txt <<__EOF__
see %license in %_datadir/license
__EOF__
for f in LGPL_EXCEPTION.txt LICENSE.PREVIEW.COMMERCIAL
do
    f2=`echo "$f"| sed 's|\.[Tt][Xx][Tt]$||'`
    install -m 0644 $f %buildroot/%_docdir/%name/${f2}.txt
done

# Install a README
install -m 0644 %SOURCE8 %buildroot/%_docdir/%name/README.ALT.txt
sed -i 's|@QT@|%name|g' %buildroot/%_docdir/%name/README.ALT.txt
sed -i 's|@QTDIR@|%qtdir|g' %buildroot/%_docdir/%name/README.ALT.txt
sed -i 's|@QtVersion@|%version|g' %buildroot/%_docdir/%name/README.ALT.txt
sed -i 's|@PackageVersion@|%version-%release|g' %buildroot/%_docdir/%name/README.ALT.txt
sed -i 's|@QTHOME@|~/.config/|g' %buildroot/%_docdir/%name/README.ALT.txt

# Install man pages
#install -d -m 0755 %buildroot/%_mandir/man1/
#for i in %_builddir/%buildsubdir/doc/man/man1/* ; do
#   install -m 0644 $i %buildroot/%_mandir/man1/
#done
#pushd %buildroot/%_mandir/man1
#    for i in $(find . -name \*.1);do
#	mv -f $i ${i}qt%major%minor%bugfix
#    done
#popd
#install -d -m 0755 %buildroot/%_mandir/man3/
#for i in %_builddir/%buildsubdir/doc/man/man3/* ; do
#   install -m 0644 $i %buildroot/%_mandir/man3/
#done
#
#pushd %buildroot/%_mandir/
#    for i in $(find . -name Q\*);do
#	perl -pi -e 's|3qt|3qt%major%minor%bugfix|g' $i
#    done
#    for i in $(find . -name \*.3qt);do
#	mv -f $i ${i}%major%minor%bugfix
#    done
#popd

# David - 3.0.1-2mdk - Install .pri files needed to build examples and demos
install -d -m 0755 %buildroot/%qtdir/src/
for i in %_builddir/%buildsubdir/src/*.pri; do
   install -m 0644 $i %buildroot/%qtdir/src/
done

%if_enabled docs
# examples and demos
> %_builddir/%buildsubdir/examples_bin_list
> %_builddir/%buildsubdir/examples_bin_list_exclude
for m in examples demos
do
    pushd %buildroot/%_datadir/%name
	find $m -type d | while read d; do mkdir -p %buildroot/%qtdir/$d; done
    popd
    pushd %buildroot/%_datadir/%name/$m
	find -type f -name Makefile | while read f; do rm -f "$f"; done
	find -type f -name \*.o | while read f; do rm -f "$f"; done
	#find -type f -name README | \
	#while read readme_file
	#do
	#    cat $readme_file >${readme_file}.tmp
	#    echo -e "Before try to build one of these $m, you need to:\n" > $readme_file
	#    echo "export QTDIR=\"%{qtdir}/\" PATH=\"%{qtdir}/bin:\$PATH\"" >> $readme_file
	#    echo -e "\n\n" >> $readme_file
	#    cat ${readme_file}.tmp >> $readme_file
	#    rm -f ${readme_file}.tmp
	#done
	find ./ -type f -executable | sed "s|^\.||" | \
	while read e
	do
	    echo "%_datadir/%name/$m/$e" >>%_builddir/%buildsubdir/examples_bin_list
	    echo "%%exclude %_datadir/%name/$m/$e" >>%_builddir/%buildsubdir/examples_bin_list_exclude
	    subdir=`dirname $e`
	    mv ./$e %buildroot/%qtdir/$m/$subdir/
	    ln -s `relative %qtdir/$m/$e %_datadir/%name/$m/$e` ./$e
	done
    popd
done
%endif

pushd %buildroot/%_datadir/%name/mkspecs/
rm -rf default
ln -sf %platform default
popd

# Install .desktop files
install -d -m 0755 %buildroot/%_desktopdir/
install -m 0644 %SOURCE21 %buildroot/%_desktopdir/%name-assistant.desktop
install -m 0644 %SOURCE22 %buildroot/%_desktopdir/%name-designer.desktop
install -m 0644 %SOURCE23 %buildroot/%_desktopdir/%name-linguist.desktop
install -m 0644 %SOURCE24 %buildroot/%_desktopdir/%name-qtconfig.desktop
install -m 0644 %SOURCE25 %buildroot/%_desktopdir/%name-qtdemo.desktop
# Icons
mkdir -p %buildroot/%_iconsdir/hicolor/{16x16,32x32,48x48,64x64}/apps
install -m 644 %SOURCE101 %buildroot/%_iconsdir/hicolor/16x16/apps/%name.png
install -m 644 %SOURCE102 %buildroot/%_iconsdir/hicolor/32x32/apps/%name.png
install -m 644 %SOURCE103 %buildroot/%_iconsdir/hicolor/48x48/apps/%name.png
install -m 644 %SOURCE104 %buildroot/%_iconsdir/hicolor/64x64/apps/%name.png



%files
%files -n lib%name
%files sql
%files devel

%files common -f qt.lang
%dir %qtdir/bin
%dir %qtdir/
%dir %qtdir/lib/
%dir %_datadir/%name/
%if_enabled docs
%dir %_datadir/%name/doc
%endif
%dir %qtdir/phrasebooks/
%dir %_datadir/%name/phrasebooks/
%dir %qtdir/translations/
%dir %_datadir/%name/translations/
%dir %qtdir/plugins/
%dir %qtdir/plugins/graphicssystems/
%dir %qtdir/plugins/codecs/
%dir %qtdir/plugins/sqldrivers/
%dir %qtdir/plugins/imageformats/
%dir %qtdir/plugins/inputmethods/
%dir %qtdir/plugins/iconengines/
%dir %qtdir/plugins/crypto/
%dir %qtdir/plugins/script/
%dir %qtdir/plugins/accessible/
%dir %qtdir/plugins/bearer/
%dir %qtdir/plugins/styles
%dir %qtdir/plugins/qmltooling
%dir %qtdir/imports/
%dir %qtdir/imports/Qt/
%dir %qtdir/imports/Qt/labs/
%dir %qtdir/imports/QtWebKit/
%qtdir/settings
%_libdir/%rname-%version
%_iconsdir/hicolor/*/apps/%name.png
%dir %_docdir/%name/
%qtdir/doc
#
%qtdir/mkspecs/
%dir %_datadir/%name/mkspecs/
#
%dir %qtdir/src/

%files -n lib%{name}-qt3support -f qtconfig.lang
%qtdir/bin/qtconfig
%_bindir/qtconfig-%name
%qtdir/lib/libQt3Support.so.*
%_libdir/libQt3Support.so.*
%qtdir/plugins/accessible/libqtaccessiblecompatwidgets.*
%_desktopdir/%name-qtconfig.desktop

%files -n lib%{name}-core
%qtdir/lib/libQtCore.so.*
%_libdir/libQtCore.so.*
%qtdir/plugins/codecs/lib*.so

%files -n lib%{name}-gui
%qtdir/lib/libQtGui.so.*
%_libdir/libQtGui.so.*
%qtdir/plugins/imageformats/libqjpeg.*
%qtdir/plugins/imageformats/libqgif.*
%qtdir/plugins/imageformats/libqmng.*
%qtdir/plugins/imageformats/libqtiff.*
%qtdir/plugins/imageformats/libqico.*
%qtdir/plugins/imageformats/libqtga.*
%qtdir/plugins/accessible/libqtaccessiblewidgets.*
%qtdir/plugins/inputmethods/libqimsw-*.*

%files -n lib%{name}-script
%qtdir/lib/libQtScript.so.*
%_libdir/libQtScript.so.*
%qtdir/plugins/script/libqtscriptdbus.so

%files -n lib%{name}-uitools
%qtdir/lib/libQtUiTools.so.*
%_libdir/libQtUiTools.so.*

%files -n lib%{name}-network
%qtdir/lib/libQtNetwork.so.*
%_libdir/libQtNetwork.so.*
%qtdir/plugins/bearer/libqgenericbearer.so
%qtdir/plugins/bearer/libqnmbearer.so
%qtdir/plugins/bearer/libqconnmanbearer.so

%files -n lib%{name}-opengl
%qtdir/lib/libQtOpenGL.so.*
%_libdir/libQtOpenGL.so.*
%qtdir/plugins/graphicssystems/libqglgraphicssystem.so
%if "%opengl_type" == "es2" || "%opengl_type" == "es1"
%qtdir/lib/libQtMeeGoGraphicsSystemHelper.so.*
%_libdir/libQtMeeGoGraphicsSystemHelper.so.*
%endif

%files -n lib%{name}-sql
%qtdir/lib/libQtSql.so.*
%_libdir/libQtSql.so.*

%files -n lib%{name}-xml
%qtdir/lib/libQtXml.so.*
%_libdir/libQtXml.so.*

%files -n lib%{name}-svg
%qtdir/lib/libQtSvg.so.*
%_libdir/libQtSvg.so.*
%qtdir/plugins/imageformats/libqsvg.so
%qtdir/plugins/iconengines/libqsvgicon.so

%files -n lib%{name}-designer
%qtdir/lib/libQtDesigner.so.*
%_libdir/libQtDesigner.so.*
%qtdir/lib/libQtDesignerComponents.so.*
%_libdir/libQtDesignerComponents.so.*

%files -n lib%{name}-multimedia
%qtdir/lib/libQtMultimedia.so.*
%_libdir/libQtMultimedia.so.*

%files -n lib%{name}-declarative
%_bindir/qmlviewer-qt4
%qtdir/bin/qmlviewer
%qtdir/lib/libQtDeclarative.so.*
%_libdir/libQtDeclarative.so.*
%qtdir/plugins/qmltooling/libqmldbg_tcp.so
%qtdir/plugins/qmltooling/libqmldbg_inspector.so
%qtdir/imports/Qt/labs/folderlistmodel
%qtdir/imports/Qt/labs/gestures
%qtdir/imports/Qt/labs/particles
%qtdir/imports/Qt/labs/shaders

%files dbus
%_bindir/qdbusviewer-%name
%qtdir/bin/qdbusviewer
%_altdir/qdbusviewer-%name
%_bindir/qdbus-%name
%qtdir/bin/qdbus
%_altdir/qdbus-%name
/usr/lib/kde4/bin/qdbus
%files -n lib%{name}-dbus
%qtdir/lib/libQtDBus.so.*
%_libdir/libQtDBus.so.*

%files -n lib%{name}-test
%qtdir/lib/libQtTest.so.*
%_libdir/libQtTest.so.*

%files -n lib%{name}-help -f qt_help.lang
%qtdir/lib/libQtHelp.so.*
%_libdir/libQtHelp.so.*
#
%qtdir/bin/qhelpconverter
%qtdir/bin/qhelpgenerator
%_bindir/qhelpconverter-%name
%_bindir/qhelpgenerator-%name

%files -n lib%{name}-clucene
%qtdir/lib/libQtCLucene.so.*
%_libdir/libQtCLucene.so.*

%files -n lib%{name}-xmlpatterns
%qtdir/bin/xmlpatterns
%qtdir/bin/xmlpatternsvalidator
%_bindir/xmlpatterns-%name
%_bindir/xmlpatternsvalidator-%name
%qtdir/lib/libQtXmlPatterns.so.*
%_libdir/libQtXmlPatterns.so.*

%files -n lib%{name}-scripttools
%qtdir/lib/libQtScriptTools.so.*
%_libdir/libQtScriptTools.so.*

%files -n lib%name-devel
%doc %_docdir/%name/*.txt
#
%_bindir/qmlplugindump-qt4
%qtdir/bin/qmlplugindump
%_bindir/qcollectiongenerator-%name
%qtdir/bin/qcollectiongenerator
%_bindir/qttracereplay-%name
%qtdir/bin/qttracereplay
%qtdir/bin/findtr
%_bindir/findtr-%name
%qtdir/bin/moc
%_bindir/moc-%name
%qtdir/bin/lrelease
%_bindir/lrelease-%name
%qtdir/bin/lconvert
%_bindir/lconvert-%name
%qtdir/bin/lupdate
%_bindir/lupdate-%name
%qtdir/bin/pixeltool
%_bindir/pixeltool-%name
%qtdir/bin/rcc
%_bindir/rcc-%name
%qtdir/bin/qt3to4
%_bindir/qt3to4-%name
%qtdir/bin/qdbuscpp2xml
%_bindir/qdbuscpp2xml-%name
%qtdir/bin/qdbusxml2cpp
%_bindir/qdbusxml2cpp-%name
%qtdir/bin/qmake
%_bindir/qmake-%name
%qtdir/bin/uic
%_bindir/uic-%name
%qtdir/bin/uic3
%_bindir/uic3-%name
%qtdir/bin/qdoc3
%_bindir/qdoc3-%name
#
%_includedir/%name
%qtdir/include
#
%qtdir/lib/*.so
%_libdir/*.so
%_libdir/*.prl
#
%qtdir/plugins/graphicssystems/libqtracegraphicssystem.so
#
%_datadir/%name/mkspecs/common
%_datadir/%name/mkspecs/features
%_datadir/%name/mkspecs/default
%_datadir/%name/mkspecs/*linux*
%_datadir/%name/mkspecs/qconfig.pri
#
%qtdir/src/*
%_datadir/%name/q3porting.xml
#
%_libdir/pkgconfig/*.pc

%files designer -f designer.lang
%_bindir/designer*
%_bindir/linguist*
#
%_datadir/%name/phrasebooks/*.qph
#
%dir %qtdir/plugins/designer
%qtdir/plugins/designer/*
%qtdir/bin/designer*
%qtdir/bin/linguist*
#
%_desktopdir/%name-linguist.desktop
%_desktopdir/%name-designer.desktop

%if_enabled sql_odbc
%files -n lib%name-sql-odbc
%qtdir/plugins/sqldrivers/libqsqlodbc.*
%endif

%if_enabled sql_pgsql
%files -n lib%name-sql-postgresql
%qtdir/plugins/sqldrivers/libqsqlpsql.*
%endif

%if_enabled sql_ibase
%files -n lib%name-sql-interbase
%qtdir/plugins/sqldrivers/libqsqlibase.*
%endif

%files -n lib%name-sql-mysql
%qtdir/plugins/sqldrivers/libqsqlmysql.*

%if_enabled sql_tds
%files -n lib%name-sql-tds
%qtdir/plugins/sqldrivers/libqsqltds.*
%endif

%files -n lib%name-sql-sqlite
%qtdir/plugins/sqldrivers/libqsqlite.*

%if_enabled sql_sqlite2
%files -n lib%name-sql-sqlite2
%qtdir/plugins/sqldrivers/libqsqlite2.*
%endif

%files assistant -f assistant.lang
%_bindir/assistant-%name
%qtdir/bin/assistant
%_desktopdir/%name-assistant.desktop

%files qvfb -f qvfb.lang
%_bindir/qvfb-%name
%qtdir/bin/qvfb
#%_desktopdir/%name-qvfb.desktop

%if_enabled docs
%files doc
%exclude %_datadir/%name/mkspecs/*

%files doc-html
%dir %_docdir/%name/
%dir %_docdir/%name/html/
%doc %_docdir/%name/html/*
%dir %_docdir/%name/src/
%doc %_docdir/%name/src/*
%dir %_docdir/%name/qch/
%doc %_docdir/%name/qch/*

%files doc-examples

%files doc-examples-bin -f examples_bin_list
%_bindir/qtdemo-%name
%qtdir/bin/qtdemo
%_desktopdir/%name-qtdemo.desktop
%qtdir/examples
%qtdir/demos

%files doc-examples-src -f examples_bin_list_exclude
%_datadir/%name/examples
%_datadir/%name/demos

#%files doc-man
#%doc %_mandir/man1/*
#%doc %_mandir/man3/*
%endif
#end if_enabled docs

%if_enabled static_thread
%files -n lib%name-devel-static
%qtdir/lib/lib*.a
%qtdir/lib/lib*.la
%endif

%files -n rpm-macros-%{name}
%_rpmmacrosdir/%name


%changelog
