Name: qtractor
Version: 0.9.90
Release: alt1

Summary: Audio/MIDI multi-track sequencer
License: GPLv2
Group: Sound
Url: https://qtractor.org/

Source: %name-%version-%release.tar

ExcludeArch: ppc64le

BuildRequires: cmake gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: ladspa_sdk
BuildRequires: pkgconfig(Qt6)
BuildRequires: pkgconfig(Qt6Svg)
BuildRequires: pkgconfig(Qt6Linguist)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(aubio)
BuildRequires: pkgconfig(dssi)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(liblo)
BuildRequires: pkgconfig(lilv-0)
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(mad)
BuildRequires: pkgconfig(rubberband)
BuildRequires: pkgconfig(samplerate)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(zlib)

%description
Qtractor is an audio/MIDI multi-track sequencer application written
in C++ with the Qt framework [1]. Target platform is Linux, where the
Jack Audio Connection Kit (JACK) for audio and the Advanced Linux
Sound Architecture (ALSA) for MIDI are the main infrastructures
to evolve as a fairly-featured Linux desktop audio workstation GUI,
specially dedicated to the personal home-studio.

%prep
%setup
%ifarch %e2k
sed -i.e2k "/#if defined(__GNUC__)/s|#|#ifdef __e2k__\nreturn true;\n#el|" \
  src/qtractor{AudioEngine,AudioMonitor,InsertPlugin,WsolaTimeStretcher}.cpp
%endif

%build
%cmake -DCONFIG_CLAP=NO -DCONFIG_VST2=NO -DCONFIG_VST3=NO
%cmake_build

%install
%cmakeinstall_std
desktop-file-edit \
	--remove-key=X-SuSE-translate \
        --remove-key=Version \
        --set-key=Exec --set-value=%name \
	%buildroot%_desktopdir/*.desktop

%files
%doc LICENSE README

%_bindir/qtractor
%_libdir/qtractor
%_datadir/qtractor

%_datadir/metainfo/*.xml
%_datadir/mime/packages/*.xml
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*.png
%_iconsdir/*/*/*/*.svg

%_man1dir/qtractor.1*

%changelog
