%define _unpackaged_files_terminate_build 1

Name: quilt
Version: 0.68
Release: alt1

Summary: Scripts for working with series of patches
License: GPLv2+
Group: Text tools
Url: https://savannah.nongnu.org/projects/quilt/
BuildArch: noarch

Provides: bash-completion-quilt = %version-%release
Obsoletes: bash-completion-quilt
Requires: diffstat
# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: ed procmail}}
# https://git.altlinux.org/gears/q/quilt.git
Source: %name-%version-%release.tar

%description
The scripts allow to manage a series of patches by keeping track of
the changes each patch makes.  Patches can be applied, un-applied,
refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://userweb.kernel.org/~akpm/stuff/patch-scripts.tar.gz.

%prep
%setup -n %name-%version-%release

%build
%define docdir %_docdir/%name
export ac_cv_path_BASH=/bin/bash
%configure \
	--with-awk=gawk \
	--with-diffstat=diffstat \
	--with-sendmail=%_sbindir/sendmail \
	--docdir=%docdir
%make_build COMPAT_SYMLINKS=sendmail RELEASE=%release

%install
%makeinstall_std COMPAT_SYMLINKS=sendmail BUILD_ROOT=%buildroot
install -pm644 AUTHORS NEWS TODO doc/README.EMACS doc/*.pdf COPYING \
	%buildroot%docdir/
%find_lang %name

%check
%make_build -k check COMPAT_SYMLINKS=sendmail

%files -f %name.lang
%config(noreplace) %_sysconfdir/quilt.quiltrc
%config /etc/bash_completion.d/*
%_bindir/*
%_man1dir/*
%_datadir/%name/
%_datadir/emacs/site-lisp/*.el*
%docdir/

%changelog
