# vim: set ft=spec: -*- rpm-spec -*-

Name: ragel6
Version: 6.10
Release: alt2.1

Summary: Ragel State Machine Compiler
Group: Development/Other
License: GPLv2
Url: http://www.complang.org/ragel/

Source: ragel-%version.tar

BuildRequires: gcc-c++ ghostscript-classic vim-devel

Conflicts: ragel

%description
Ragel compiles executable finite state machines from regular
languages. Ragel targets C, C++, Objective-C, D, Java and Ruby.
Ragel state machines can not only recognize byte sequences as
regular expression machines do, but can also execute code at
arbitrary points in the recognition of a regular language. Code
embedding is done using inline operators that do not disrupt the
regular language syntax.

%package -n vim-plugin-ragel6-syntax
Summary: Vim syntax for Ragel
Group: Editors
PreReq: vim-common
Conflicts: vim-plugin-ragel-syntax

%description -n vim-plugin-ragel6-syntax
Vim syntax for Ragel.

%prep
%setup -n ragel-%version

%build
%add_optflags -fpermissive
export CPPFLAGS="%optflags"
%configure --docdir=%_docdir/ragel6-%version
%make_build
%make_build -C doc

%install
mkdir -p %buildroot{%vim_syntax_dir,%vim_ftdetect_dir}
%makeinstall_std
%makeinstall_std -C doc
cp CREDITS README TODO %buildroot%_docdir/ragel6-%version

install -p -m644 ragel.vim %buildroot%vim_syntax_dir/
cat <<EOF >%buildroot%vim_ftdetect_dir/ragel.vim
au BufNewFile,BufRead *.rl  setf ragel
EOF

%check
#make -C test check

%files
%doc %_docdir/ragel6-%version
%_bindir/*
%_man1dir/*

%files -n vim-plugin-ragel6-syntax
%vim_syntax_dir/ragel.vim
%vim_ftdetect_dir/ragel.vim

%changelog
