%define testname sisyphus_check
%define sisyphus_check_ver 0.8.14
%define sisyphus_check_rel alt1
Name: repocop-unittest-%testname
Version: 0.6.3
Requires: sisyphus_check >= %sisyphus_check_ver
#Requires: sisyphus_check = %sisyphus_check_ver-%sisyphus_check_rel
Release: %sisyphus_check_rel
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: %testname intergration tests for repocop test platform
Group: Development/Other
License: GPL or Artistic
Url: http://repocop.altlinux.org 
Requires: repocop

%description
%testname intergration test for repocop test platform.
The test checks packages using sisyphus_check utility.

%prep

%build
cat > sisyphus_check.test <<'EOF'
#!/bin/bash
# gpg,buildhost,buildtime are in separate test %name-check-gpg
# check-group is too rpm-sensitive; also, GROUPS are monotonic.
if sisyphus_check --verbose --files \
   --no-check-gpg --no-check-buildhost --no-check-buildtime --no-check-dirlist \
   --no-check-group \
   $REPOCOP_PKG > $REPOCOP_TEST_TMPDIR/msg 2>&1; then
    exec repocop-test-ok
else
    exec repocop-test-fail "sisyphus_check failed: " `cat $REPOCOP_TEST_TMPDIR/msg`;
fi
EOF

%install
mkdir -p $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/
%__install -m 755 %testname.test $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/test
cat > $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/options <<EOF
need_unpack=0
EOF
touch $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/build.timestamp

%triggerin -- sisyphus_check
# if test itself is installed/updated, just keep build timestamp
[ $2 = 1 ] && exit 0 ||:
# at every sisyphus_check change we should bump timestamp
# to discard cached results of old sisyphus_check
touch %_datadir/repocop/pkgtests/%testname/test

%files
#doc README ChangeLog
%_datadir/repocop/pkgtests/%testname

%changelog
