%define testname systemd-but-no-native-init

Name: repocop-unittest-%testname
Version: 0.06
Release: alt1
BuildArch: noarch
Packager: Igor Vlasenko <viy@altlinux.ru>
Requires: repocop > 0.55
Url: http://repocop.altlinux.org

Summary: %testname integration tests for repocop test platform.
Group: Development/Other
License: GPLv2+

%description
The test warns packages that have support for
systemd but not for Sys-V init


%prep

%build
cat > %testname.posttest <<'EOF'
#!/bin/sh
sqlite3 "$REPOCOP_TEST_DBDIR/rpm.db" <<EOSQL
.mode tabs
.output $REPOCOP_TEST_TMPDIR/pre
select a.pkgid,a.filename from rpm_files as a where (a.filename glob '/lib/systemd/system/*.service' or a.filename glob '/usr/lib/systemd/system/*.service') and a.pkgid not in (select c.pkgid from rpm_files as c where c.filename glob '/etc/rc.d/init.d/*' or c.filename glob '/etc/xinetd.d/*');
EOSQL

touch $REPOCOP_TEST_TMPDIR/msg

sed -i -e '/^service-/d;/^systemd-/d' $REPOCOP_TEST_TMPDIR/pre
cat $REPOCOP_TEST_TMPDIR/pre | while read -r pkgid service; do
    servicename=${service##/usr}
    servicename=${servicename##/lib/systemd/system/}
    case $pkgid in
    	 daemontools-*|wpa_supplicant-* ) : nothing
	 ;;
	 *)
	 servicepath=$REPOCOP_STATEDIR/systemd/$pkgid/system/$servicename

	 if [ -e $servicepath ] ; then
	     :
	     if grep -q '^Type=dbus' $servicepath || grep -q '^Alias=display-manager.service' $servicepath; then
	     	  :
	     else
		echo $pkgid >> $REPOCOP_TEST_TMPDIR/msg
	     fi
	 fi
	 ;;
    esac
done

sort -u $REPOCOP_TEST_TMPDIR/msg | repocop-test-import-tsv -s experimental -m "The package have native systemd file(s) but no  SysV init scripts."
rm $REPOCOP_TEST_TMPDIR/*
EOF

%install
for i in *.posttest; do
    testname=`echo $i | sed -e s,.posttest\$,,`
    install -pD -m 755 $testname.posttest %buildroot%_datadir/repocop/pkgtests/$testname/posttest
done

#mkdir -p %buildroot%_datadir/repocop/fixscripts/
#install -p -m 755 *.pl %buildroot%_datadir/repocop/fixscripts/

%files
%_datadir/repocop/pkgtests/%testname/
#%_datadir/repocop/fixscripts/*.pl

%changelog
