%def_disable snapshot

%define ver_major 3.4
%define rev %nil
%define api_ver 3.0
%define xdg_name org.gnome.Rhythmbox3
%define gst_api_ver 1.0

%def_enable gudev
%def_enable vala
%def_enable doc
%def_enable daap
%def_enable grilo
%def_enable mtp
%def_enable zeitgeist
%def_disable magnatune
# disabled since 3.4.5
%def_disable sample_plugins
# removed since 3.4.5
%def_disable soundcloud
%def_disable mmkeys
# based on WebKit1
%def_disable context

Name: rhythmbox
Version: %ver_major.8
Release: alt1%rev

Summary: Music Management Application
License: GPL-2.0-or-later
Group: Sound
Url: https://wiki.gnome.org/Apps/Rhythmbox

Vcs: https://gitlab.gnome.org/GNOME/rhythmbox.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define pkgdocdir %_docdir/%name-%version

%define dbus_ver 0.35
%define glib_ver 2.66.0
%define gst_ver 1.0
%define gtk_ver 3.20.0
%define mtp_ver 0.3
%define brasero_ver 2.31.5
%define soup3_ver 3.0.7
%define totem_ver 3.2.0
%define udev_ver 143
%define gpod_ver 0.8
%define mx_ver 1.0.1
%define secret_ver 0.18
%define dmapsharing_ver 3.9.11
%define grilo_ver 0.3

Requires: lib%name = %EVR

Requires: gstreamer%gst_api_ver >= %gst_ver
Requires: libgst-plugins%gst_api_ver >= %gst_ver
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gnome-icon-theme
Requires: gnome-icon-theme-symbolic
Requires: libpeas-python3-loader

Provides: %name-plugins-audiocd
Provides: %name-plugins-generic-player

%define _libexecdir %_libdir/%name
%add_python3_path %_libexecdir
%add_python3_path %_libdir/%name/plugins

# python bindings are linked into rhythmbox statically
Provides: python%__python3_version(rb)
Provides: python%__python3_version(rhythmdb)
Provides: python3(rb)
Provides: python3(rhythmdb)

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson
BuildRequires: python3-module-pygobject3-devel
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: yelp-tools desktop-file-utils %_bindir/appstream-util
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libdbus-glib-devel >= %dbus_ver
BuildRequires: libsoup3.0-devel >= %soup3_ver
BuildRequires: libbrasero-devel >= %brasero_ver
BuildRequires: libtotem-pl-parser-devel >= %totem_ver
BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver
BuildRequires: gstreamer%gst_api_ver-utils >= %gst_ver
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: libgpod-devel >= %gpod_ver
BuildRequires: libICE-devel libSM-devel libsecret-devel >= %secret_ver
BuildRequires: iso-codes-devel libcheck-devel
BuildRequires: liblirc-devel libnotify-devel >= 0.7.3
BuildRequires: libxml2-devel libjson-glib-devel libpng-devel
BuildRequires: libpeas-devel libtdb-devel zlib-devel
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_doc:BuildRequires: gi-docgen}
%{?_enable_mtp:BuildRequires: libmtp-devel >= %mtp_ver}
%{?_enable_grilo:BuildRequires: libgrilo-devel >= %grilo_ver}
BuildRequires: libavahi-glib-devel
%{?_enable_daap:BuildRequires: pkgconfig(libdmapsharing-4.0) >= %dmapsharing_ver}
%{?_enable_gudev:BuildRequires: libgudev-devel}
BuildRequires: libgtk+3-gir-devel libgstreamer%gst_api_ver-gir-devel gst-plugins%gst_api_ver-gir-devel

%description
Rhythmbox is an integrated music management application, supporting
a music library, multiple playlists, internet radio, and more.

%package -n lib%name
Summary: Shared Rhythmbox Library
Group: System/Libraries

%description -n lib%name
This package provides shared library needed for Rhythmbox to work

%package -n lib%name-devel
Summary: Development files for Rhythmbox library
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Files needed to develop applications that manipulate Rhythmbox,
an integrated music management application.

%package devel-doc
Summary: API documentation for Rhythmbox
Group: Development/C
BuildArch: noarch
Conflicts: lib%name < %version

%description devel-doc
API documentation for Rhythmbox, an integrated music management application.

%package plugins-audioscrobbler
Summary: Audioscrobbler plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-audioscrobbler
Plugin to the Rhythmbox music manager that adds
Audioscrobbler (Last.fm) service support.

%package plugins-cd-recorder
Summary: CD recorder plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR
Requires: brasero >= %brasero_ver

%description plugins-cd-recorder
Plugin to the Rhythmbox music manager that provides
support for recording audio CDs from playlists

%package plugins-daap
Summary: DAAP plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-daap
Plugin to the Rhythmbox music manager that provides
support for DAAP Music Sharing

%package plugins-fmradio
Summary: FM radio plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-fmradio
Plugin to the Rhythmbox music manager that provides
Support for FM radio broadcasting services

%package plugins-ipod
Summary: iPod plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR
%description plugins-ipod
Plugin to the Rhythmbox music manager that adds
support for Apple iPod media player.

%package plugins-mtpdevice
Summary: MTP device plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-mtpdevice
Plugin to the Rhythmbox music manager that adds
support for MTP devices.

%package plugins-iradio
Summary: Internet Radio plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR
%description plugins-iradio
Plugin to the Rhythmbox music manager that provides
support for Internel Radio

%package plugins-lirc
Summary: LIRC plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-lirc
Plugin to the Rhythmbox music manager that adds
Linux Infrared Remote Control support.

%package plugins-mmkeys
Summary: Media Player Keys plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-mmkeys
Plugin to the Rhythmbox music manager that provides
control Rhythmbox using key shortcuts

%package plugins-power-manager
Summary: Power Manager plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-power-manager
Plugin to the Rhythmbox music manager that provides
inhibit Power Manager from suspending the machine while playing

%package plugins-im-status
Summary: IM status plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-im-status
This plugin updates IM status according to the current song (works with
Empathy & Gossip)

%package plugins-notification
Summary: Status icon plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-notification
Status icon and notification popups plugin for Rhythmbox

%package plugins-media-server
Summary: MediaServer2 D-Bus interface for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-media-server
This plugin provides an implementation of the MediaServer2 D-Bus
interface specification for Rhythmbox.

%package plugins-mpris
Summary: MPRIS D-Bus interface for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-mpris
This plugin provides an implementation of the MPRIS D-Bus interface
specification for Rhythmbox.

%package plugins-grilo
Summary: Grilo browser for Rhythmbox
Group: Sound
Requires: %name = %EVR

%description plugins-grilo
A plugin to let you browse media content from various sources using
Grilo.

%package plugins-android
Summary: Android plugin for Rhythmbox
Group: Sound
Requires: %name = %EVR
Requires: gvfs-backend-mtp

%description plugins-android
A plugin that supports Android 4.0+ devices (via MTP).

%package plugins-python
Summary: Python plugins for Rhythmbox
Group: Sound
Requires: %name = %EVR
Requires: lib%name-gir = %EVR
Requires: typelib(Soup) = 3.0
%{?_enable_context:Requires: typelib(WebKit) = 1.0}
%{?_enable_zeitgeist:Requires: zeitgeist}

%description plugins-python
Python scripting language capabilities and several Python plugins
to the Rhythmbox music manager.

%package -n lib%name-gir
Summary: GObject introspection data for the Gedit
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Rhythmbox music manager/

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Rhythmbox
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Rhythmbox music manager.


%package plugins
Summary: All plugins for Rhythmbox
Group: Sound
BuildArch: noarch

Requires: %name-plugins-audioscrobbler = %EVR
Requires: %name-plugins-cd-recorder = %EVR
%{?_enable_daap:Requires: %name-plugins-daap = %EVR}
Requires: %name-plugins-fmradio = %EVR
%{?_enable_ipod:Requires: %name-plugins-ipod = %EVR}
Requires: %name-plugins-iradio = %EVR
%{?_enable_lirc:Requires: %name-plugins-lirc = %EVR}
%{?_enable_mmkeys:Requires: %name-plugins-mmkeys = %EVR}
%{?_enable_mtp:Requires: %name-plugins-mtpdevice = %EVR}
Requires: %name-plugins-power-manager = %EVR
Requires: %name-plugins-im-status = %EVR
Requires: %name-plugins-notification = %EVR
Requires: %name-plugins-media-server = %EVR
Requires: %name-plugins-mpris = %EVR
%{?_enable_grilo:Requires: %name-plugins-grilo = %EVR}
Requires: %name-plugins-android = %EVR
Requires: %name-plugins-python = %EVR

%description plugins
This virtual package installs all Rhythmbox plugins

%prep
%setup -n %name-%version

%build
%add_optflags %(getconf LFS_CFLAGS)
%meson \
    %{subst_enable_meson_bool doc apidoc} \
    %{subst_enable_meson_feature gudev gudev} \
    %{subst_enable_meson_feature lirc lirc} \
    %{subst_enable_meson_feature brasero brasero} \
    %{subst_enable_meson_feature mtp mtp} \
    %{subst_enable_meson_feature ipod ipod} \
    %{subst_enable_meson_feature daap daap} \
    %{subst_enable_meson_feature vala plugins_vala} \
    %{subst_enable_meson_bool sample_plugins sample-plugins}
%nil
%meson_build

%install
%meson_install
install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS DOCUMENTERS MAINTAINERS ChangeLog README* NEWS THANKS %buildroot%pkgdocdir/
bzip2 -9 %buildroot%pkgdocdir/ChangeLog
ln -s %_licensedir/GPL-2.0 %buildroot%pkgdocdir/COPYING

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/rhythmbox-metadata
%_libdir/%name/plugins/generic-player
%_libdir/%name/plugins/audiocd
%_datadir/%name
%_datadir/applications/*
%_datadir/dbus-1/services/*
%_datadir/icons/hicolor/*/*/*
%_man1dir/*
%config %_datadir/glib-2.0/schemas/org.gnome.rhythmbox.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%dir %pkgdocdir
%doc %pkgdocdir/AUTHORS
%doc %pkgdocdir/DOCUMENTERS
%doc %pkgdocdir/MAINTAINERS
%doc %pkgdocdir/COPYING
%doc %pkgdocdir/ChangeLog.bz2
%doc %pkgdocdir/NEWS
%doc %pkgdocdir/README*
%doc %pkgdocdir/THANKS

%files -n lib%name
%_libdir/lib%name-core.so.*

%files -n lib%name-devel
%_libdir/lib%name-core.so
%_includedir/%name/
%_libdir/pkgconfig/%name.pc
%{?_enable_vala:%_vapidir/rb.vapi
%_vapidir/rhythmdb.vapi}

%files plugins-audioscrobbler
%_libdir/%name/plugins/audioscrobbler/

%files plugins-cd-recorder
%_libdir/%name/plugins/cd-recorder/

%if_enabled daap
%files plugins-daap
%_libdir/%name/plugins/daap/
%endif

%files plugins-fmradio
%_libdir/%name/plugins/fmradio/

%files plugins-ipod
%_libdir/%name/plugins/ipod/

%if_enabled mtp
%files plugins-mtpdevice
%_libdir/%name/plugins/mtpdevice/
%endif

%files plugins-iradio
%_libdir/%name/plugins/iradio/

%files plugins-lirc
%_libdir/%name/plugins/rblirc/

%if_enabled mmkeys
%files plugins-mmkeys
%_libdir/%name/plugins/mmkeys/
%endif

%files plugins-power-manager
%_libdir/%name/plugins/power-manager/

%files plugins-im-status
%_libdir/%name/plugins/im-status/

%files plugins-notification
%_libdir/%name/plugins/notification/

%files plugins-media-server
%_libdir/%name/plugins/dbus-media-server/

%files plugins-mpris
%_libdir/%name/plugins/mpris/

%if_enabled grilo
%files plugins-grilo
%_libdir/%name/plugins/grilo/
%endif

%files plugins-android
%_libdir/%name/plugins/android/

%files -n lib%name-gir
%_libdir/girepository-1.0/MPID-%api_ver.typelib
%_libdir/girepository-1.0/RB-%api_ver.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/MPID-%api_ver.gir
%_datadir/gir-1.0/RB-%api_ver.gir

%files plugins-python
%_libdir/%name/plugins/rb/
%_libdir/%name/plugins/python-console/
%_libdir/%name/plugins/artsearch/
%_libdir/%name/plugins/lyrics/
%{?_disable_magnatune:%exclude %_libdir/%name/plugins/magnatune/}
%_libdir/%name/plugins/replaygain/
%_libdir/%name/plugins/webremote/
%_libdir/%name/plugins/listenbrainz/
%{?_enable_zeitgeist:%_libdir/%name/plugins/rbzeitgeist/}
%{?_enable_soundcloud:%_libdir/%name/plugins/soundcloud/}

%files plugins

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%name-%version/
%endif

%changelog
