%define optflags_lto %nil

%define git_ver 17986
%define git_commit 68d25733443297c892b956fff8cd3e7c38c3744e

%define glslang_version 15.3.0
%define asmjit_commit 416f7356967c1f66784dc1580fe157f9406d8bff
%define hidapi_commit f42423643ec9011c98cccc0bb790722bbbd3f30b
%define yaml_cpp_commit 456c68f452da09d8ca84b375faa2b1397713eaba
%define soundtouch_commit 3982730833b6daefe77dcfb32b5c282851640c17
%define miniupnp_version miniupnpd_2_3_9
%define rtmidi_version 6.0.0
%define zstd_version 1.5.7
%define openal_version 1.24.3
%define fusion_version 1.2.8
%define vulkan_memory_allocator_version 3.3.0

Name: rpcs3
Version: 0.0.37
Release: alt1

Summary: PS3 emulator/debugger
License: GPLv2
Group: Emulators

Url: https://%name.net/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64

# https://github.com/RPCS3/%name/archive/v%version/%name-%version.tar.gz
Source0: %name-%version.tar
# https://github.com/KhronosGroup/glslang/archive/%glslang_version/glslang-%glslang_version.tar.gz
Source1: glslang-%glslang_version.tar
# https://github.com/RPCS3/asmjit/archive/%asmjit_commit/asmjit-%asmjit_commit.tar.gz
Source2: asmjit-%asmjit_commit.tar
# https://github.com/RPCS3/hidapi/archive/%hidapi_commit/hidapi-%hidapi_commit.tar.gz
Source3: hidapi-%hidapi_commit.tar
# https://github.com/RPCS3/yaml-cpp/archive/%yaml_cpp_commit/yaml-cpp-%yaml_cpp_commit.tar.gz
Source4: yaml-cpp-%yaml_cpp_commit.tar
# https://github.com/RPCS3/soundtouch/archive/%soundtouch_commit/soundtouch-%soundtouch_commit.tar.gz
Source5: soundtouch-%soundtouch_commit.tar
# https://github.com/miniupnp/miniupnp/archive/%miniupnp_version/miniupnp-%miniupnp_version.tar.gz
Source6: miniupnp-%miniupnp_version.tar
# https://github.com/thestk/rtmidi/archive/refs/tags/%rtmidi_version/rtmidi-%rtmidi_version.tar.gz
Source7: rtmidi-%rtmidi_version.tar
# https://github.com/facebook/zstd/archive/v%zstd_version/zstd-%zstd_version.tar.gz
Source8: zstd-%zstd_version.tar
# https://github.com/kcat/openal-soft/archive/%openal_version/openal-soft-%openal_version.tar.gz
Source9: openal-soft-%openal_version.tar
# https://github.com/xioTechnologies/Fusion/archive/v%fusion_version/Fusion-%fusion_version.tar.gz
Source10: Fusion-%fusion_version.tar
# https://github.com/GPUOpen-LibrariesAndSDKs/VulkanMemoryAllocator/archive/v%vulkan_memory_allocator_version/VulkanMemoryAllocator-%vulkan_memory_allocator_version.tar.gz
Source11: VulkanMemoryAllocator-%vulkan_memory_allocator_version.tar

BuildRequires: /proc
BuildRequires: clang
BuildRequires: clang-tools
BuildRequires: glslang
BuildRequires: glslc
BuildRequires: libGLEW-devel
BuildRequires: libSDL2-devel
BuildRequires: libSDL3-devel
BuildRequires: libalsa-devel
BuildRequires: libavformat-devel
BuildRequires: libcubeb-devel
BuildRequires: libcurl-devel
BuildRequires: libe2fs
BuildRequires: libedit-devel
BuildRequires: libevdev-devel
BuildRequires: libfaudio-devel
BuildRequires: libffi-devel
BuildRequires: libflatbuffers-devel
BuildRequires: libfreeglut
BuildRequires: libglade
BuildRequires: libgraphviz
BuildRequires: libgtkglext
BuildRequires: libopenal-devel
BuildRequires: libopencv-devel
BuildRequires: libpng-devel
BuildRequires: libpugixml-devel
BuildRequires: libqt6-labsqmlmodels
BuildRequires: libstb-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libvulkan-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: libwolfssl-devel
BuildRequires: libxml2-devel
BuildRequires: lld
BuildRequires: llvm
BuildRequires: llvm-devel
BuildRequires: pipewire-jack-libs-devel
BuildRequires: qt6-multimedia-devel
BuildRequires: qt6-svg-devel

%description
The world's first free and open-source PlayStation 3 emulator/debugger, written in C++ for Windows and Linux.

%prep
%setup -b 1 -b 2 -b 3 -b 4 -b 5 -b 6 -b 7 -b 8 -b 9 -b 10 -b 11

%__mv -Tf ../glslang-%glslang_version 3rdparty/glslang/glslang
%__mv -Tf ../asmjit-%asmjit_commit 3rdparty/asmjit/asmjit
%__mv -Tf ../hidapi-%hidapi_commit 3rdparty/hidapi/hidapi
%__mv -Tf ../yaml-cpp-%yaml_cpp_commit 3rdparty/yaml-cpp/yaml-cpp
%__mv -Tf ../soundtouch-%soundtouch_commit 3rdparty/SoundTouch/soundtouch
%__mv -Tf ../miniupnp-%miniupnp_version 3rdparty/miniupnp/miniupnp
%__mv -Tf ../rtmidi-%rtmidi_version 3rdparty/rtmidi/rtmidi
%__mv -Tf ../zstd-%zstd_version 3rdparty/zstd/zstd
%__mv -Tf ../openal-soft-%openal_version 3rdparty/OpenAL/openal-soft
%__mv -Tf ../Fusion-%fusion_version 3rdparty/fusion/fusion
%__mv -Tf ../VulkanMemoryAllocator-%vulkan_memory_allocator_version 3rdparty/GPUOpen/VulkanMemoryAllocator

#Generate Version Strings
GIT_VERSION=$(echo %git_ver)
GIT_COMMIT=$(echo %git_commit)

echo "// This is a generated file.

#define RPCS3_GIT_VERSION \"$GIT_VERSION-${GIT_COMMIT:0:8}\"
#define RPCS3_GIT_BRANCH \"master\"
#define RPCS3_GIT_FULL_BRANCH \"RPCS3/rpcs3/master\"

// If you don't want this file to update/recompile, change to 1.
#define RPCS3_GIT_VERSION_NO_UPDATE 1
" > %name/git-version.h

%build
%add_optflags -I%_includedir/stb

export CC="clang"
export CXX="clang++"
export RANLIB="llvm-ranlib"
export AR="llvm-ar"
export NM="llvm-nm"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"

%cmake \
	-DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
	-DUSE_NATIVE_INSTRUCTIONS:BOOL=FALSE \
	-DUSE_SYSTEM_FFMPEG:BOOL=TRUE \
	-DUSE_SYSTEM_LIBPNG:BOOL=TRUE \
	-DUSE_SYSTEM_LIBUSB:BOOL=TRUE \
	-DUSE_SYSTEM_FLATBUFFERS:BOOL=TRUE \
	-DUSE_SYSTEM_PUGIXML:BOOL=TRUE \
	-DUSE_SYSTEM_WOLFSSL:BOOL=TRUE \
	-DUSE_SYSTEM_FAUDIO:BOOL=TRUE \
	-DUSE_SYSTEM_CUBEB:BOOL=TRUE \
	-DLLVM_DIR:PATH=$(llvm-config --cmakedir) \
	-GNinja \
	-Wno-dev

%cmake_build

%install
%cmake_install

%__rm -rf %buildroot%_datadir/%name/{git,test}

%files
%doc LICENSE README.md
%_bindir/%name
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/%name
%_datadir/metainfo/%name.metainfo.xml

%changelog
