Name: s3backer
Version: 2.1.2
Release: alt1

Summary: FUSE-based single file backing store via Amazon S3
License: GPLv2
Group: System/Kernel and hardware
Url: https://github.com/archiecobbs/s3backer

Requires: fuse

Source: %name-%version-%release.tar
BuildRequires: libcurl-devel libexpat-devel libfuse-devel libssl-devel libzstd-devel zlib-devel

%description
s3backer is a filesystem that contains a single file backed by the Amazon S3.
As a filesystem, it is very simple: it provides a single normal file having
a fixed size.  Underneath, the file is divided up into blocks, and the content
of each block is stored in a unique Amazon S3 object.  In other words, what
s3backer provides is really more like an S3-backed virtual hard disk device,
rather than a filesystem.

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%global _customdocdir %_defaultdocdir/%name

%files
%doc README
%_bindir/s3backer
%_man1dir/s3backer.1*

%changelog
