%define script_name winbind-dnsupdate

Name: samba-winbind-dnsupdate
Version: 0.7.1
Release: alt1

Summary: Dynamic dns update for winbind backend
License: GPLv3
Group: System/Configuration/Networking

URL: https://github.com/altlinuxteam/samba-winbind-dnsupdate
VCS: https://github.com/altlinuxteam/samba-winbind-dnsupdate

Source: %name-%version.tar

# actually not anymore but e2k has a standalone girar
BuildArch: noarch
%ifnarch %e2k
BuildRequires: shellcheck
%endif

Requires: samba-winbind

%description
A program that implements dynamic update of addresses
on a DNS server when used as a winbind backend

%prep
%setup

%build
# Change version
sed -i 's/^VERSION=.*/VERSION=%version/' %script_name

%install

install -Dm 755 %script_name %buildroot/%_bindir/%script_name
install -Dm 644 %script_name.bash-completion \
     %buildroot%_datadir/bash-completion/completions/%script_name
install -Dm 644 %script_name.timer %buildroot%_unitdir/%script_name.timer
install -Dm 644 %script_name.service %buildroot%_unitdir/%script_name.service
install -Dm 644 %script_name.sysconfig %buildroot%_sysconfdir/sysconfig/%script_name
install -Dm 644 doc/winbind-dnsupdate.1 %buildroot/%_man1dir/winbind-dnsupdate.1
install -Dm 644 org.altlinux.winbind.dnsupdate.gschema.xml \
      %buildroot%_datadir/glib-2.0/schemas/org.altlinux.winbind.dnsupdate.gschema.xml

%check
%ifnarch %e2k
shellcheck %script_name
%endif

%files
%doc README.md
%_bindir/%script_name
%_unitdir/%script_name.timer
%_unitdir/%script_name.service
%_datadir/bash-completion/completions/%script_name
%_sysconfdir/sysconfig/%script_name
%_man1dir/winbind-dnsupdate.1.*
%_datadir/glib-2.0/schemas/org.altlinux.winbind.dnsupdate.gschema.xml

%changelog
