# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: sbsigntools
Version: 0.9.5
Release: alt3
Summary: Signing utility for UEFI secure boot
License: GPL-3.0-or-later
Url: https://git.kernel.org/pub/scm/linux/kernel/git/jejb/sbsigntools.git
# Url(ccan): http://ccodearchive.net/
# Vcs(ccan): https://github.com/rustyrussell/ccan
Group: Development/Other

Source: %name-%version.tar
Patch3500: alt-loongarch64.patch

ExcludeArch: ppc64le
BuildRequires: binutils-devel
BuildRequires: gnu-efi
BuildRequires: help2man
BuildRequires: libuuid-devel
BuildRequires: openssl
BuildRequires: openssl-devel

%description
Tools to add signatures to EFI binaries and drivers.

%prep
%setup
%patch3500 -p1

%build
%define optflags_lto %nil
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%check
%make_build check

%files
%doc README AUTHORS LICENSE.GPLv3 COPYING ChangeLog NEWS
%_bindir/sbattach
%_bindir/sbkeysync
%_bindir/sbsiglist
%_bindir/sbsign
%_bindir/sbvarsign
%_bindir/sbverify
%_man1dir/*.1*

%changelog
