Name: scanlogd
Version: 2.2.8
Release: alt1

Summary: A tool to detect and log TCP port scans
License: GPLv2+
Group: System/Servers
Url: https://www.openwall.com/scanlogd/
Packager: Dmitry V. Levin <ldv@altlinux.org>
# git://git.altlinux.org/gears/s/scanlogd.git
Source: %name-%version-%release.tar

%description
scanlogd detects port scans and writes one line per scan via the
syslog(3) mechanism.  If a source address sends multiple packets to
different ports in a short time, the event will be logged.

%prep
%setup -n %name-%version-%release

%build
make clean
make linux CFLAGS="-c $RPM_OPT_FLAGS %optflags_notraceback $(getconf LFS_CFLAGS)" LDFLAGS=

%install
mkdir -p %buildroot{%_sbindir,%_mandir/man8,%_initdir}
install -pm755 scanlogd %buildroot%_sbindir/
install -pm644 scanlogd.8 %buildroot%_man8dir/
install -pm755 scanlogd.init %buildroot%_initdir/%name

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%post
/usr/sbin/groupadd -r -f %name
/usr/sbin/useradd -r -g %name -d /dev/null -s /dev/null -n %name >/dev/null 2>&1 ||:
%post_service %name

%preun
%preun_service %name

%files
%config %_initdir/*
%_sbindir/*
%_mandir/man?/*

%changelog
