Name: scanssh
Version: 2.1.2
Release: alt1
Epoch: 1

Summary: Network scaner for SSH servers and open proxies
License: BSD-3-Clause and BSD-4-Clause
Group: Monitoring
Url: https://github.com/ofalk/scanssh/wiki

# https://github.com/ofalk/scanssh/archive/%version.tar.gz
Source: scanssh-%version.tar
Source1: scanssh.control
Patch1: scanssh-rh-configure.patch
Patch2: scanssh-rh-makefile.patch
Patch3: scanssh-alt-configure.patch
Patch4: scanssh-2.0-alt-log.patch
Patch5: scanssh-2.1-alt-warnings.patch

Requires: control >= 0.6.1
BuildRequires: libdnet-devel libevent-devel libpcap-devel

Summary(ru_RU.UTF-8): Сетевой сканер SSH-серверов и открытых прокси

%description
ScanSSH supports scanning a list of addresses and networks for open
proxies, SSH protocol servers, Web and SMTP servers.  Where possible
ScanSSH, displays the version number of the running services.  ScanSSH
protocol scanner supports random selection of IP addresses from large
network ranges and is useful for gathering statistics on the deployment
of SSH protocol servers in a company or the Internet as whole.

%description -l ru_RU.UTF-8
ScanSSH сканирует сеть по заданным адресам, выводя адреса узлов
с обнаруженными работающими сервисами SSH, WWW, SMTP и Веб-прокси.
Там, где это возможно, выводится также номер версии сервиса.
Данная утилита полезна для сбора статистики об использовании сервисов
и проверки их версий в большой локальной сети.

По функциональности ScanSSH отчасти пересекается
с более известной утилитой nmap, которая выдаёт информацию
по большему количеству сервисов, но с меньшей детальностью.
Используйте ScanSSH либо для проверки фиксированной конфигурации,
либо получив предварительные результаты через nmap.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
chmod 700 %buildroot%_bindir/scanssh
install -pD -m755 %_sourcedir/scanssh.control %buildroot%_controldir/scanssh

%pre
%pre_control scanssh

%post
/usr/sbin/groupadd -r -f netadmin
%post_control -s netadmin scanssh

%files
%config %_controldir/scanssh
%_bindir/*
%_mandir/man?/*
%doc README.md

%changelog
