%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%set_automake_version 1.11

%define lang_path 	./data/lang
%define data_path 	./data
%define ru_tips 	%lang_path/tips_RU.txt
%define ru_tutor 	%lang_path/tutorial_RU.xml
%define ru_lang_res 	%lang_path/lang_RU.resource

Name:    scorched3d
Version: 44
Release: alt3
License: GPL
Group:   Games/Arcade
Summary: A 3D version of the classic DOS game Scorched Earth
Summary(ru_RU.UTF8): 3D версия классической DOS игрушки - Scorched Earth.
URL: http://www.scorched3d.co.uk

Source: %name-%version.tar
Source1: %name.desktop
Source2: %name-16.png
Source3: %name-32.png
Source4: %name-48.png

Patch1: configure.ac.patch
Patch2: %name-%version-fedora-help.patch
Patch3: %name-%version-fedora-system-lua.patch
Patch4: %name-%version-fedora-syslibs.patch
Patch5: %name-%version-fedora-returntype.patch
Patch6: %name-%version-alt-thumbsdb.patch
Patch7: %name-%version-alt-wxGTK-compat.patch
# https://sources.debian.org/patches/scorched3d/44+dfsg-7/lua-5.4.patch/
Patch8: %name-%version-lua-5.4.patch

BuildRequires: gcc-c++ libGL-devel libSDL-devel libSDL_net-devel
BuildRequires: libexpat-devel libfftw3-devel libjpeg-devel
BuildRequires: libopenal-devel libpango-devel libpng-devel
BuildRequires: libvorbis-devel libwxGTK3.0-devel libogg-devel
BuildRequires: libalut-devel hd2u findutils
BuildRequires: liblua-devel libGLEW-devel

Requires: %name-data = %EVR

%description
Scorched 3D is a game based loosely on the classic DOS game Scorched
Earth "The Mother Of All Games".

%description -l ru_RU.UTF-8
Scorched 3D — компьютерная игра, римейк пошаговой артиллерийской стратегии Scorched Earth.
Игра полностью переработана на трёхмерную графику. В отличии от оригинальной Scorched Earth,
которая является shareware-игрой, Scorched 3D является полностью бесплатной и распостраняется на
условиях лицензии GNU. Играть можно против компьютерного соперника или по сети. Присутствует также
коллективная игра, за одним компьютером могут играть до 24 игрока. (c) wiki

%package data
Summary: Data files for Scorched 3D
Group: Games/Arcade
BuildArch: noarch

%description data
Scorched 3D is a game based loosely on the classic DOS game Scorched
Earth "The Mother Of All Games".

This package contains data files for Scorched 3D.

%prep
%setup -n scorched
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p0
%patch6 -p3
%patch7 -p3
%patch8 -p1

# ensure we use the system versions of these
rm -f src/common/common/snprintf.c
rm -f src/common/lua/l*.{cpp,h}
rm -f src/common/lua/print.cpp

%build
%add_optflags -D_FILE_OFFSET_BITS=64

/bin/touch {INSTALL,AUTHORS,COPYING,ChangeLog,NEWS}
export OPENAL_CONFIG=%_bindir/openal-config
export FREEALUT_CONFIG=%_bindir/freealut-config

#repocop Thumbs.db
find \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete

echo RU > %lang_path/language.ini
dos2unix %ru_tips
dos2unix %ru_tutor
dos2unix %ru_lang_res

%autoreconf
%configure \
	--bindir=%_gamesbindir \
	--datadir=%_gamesdatadir/%name \
	--libdir=%_libdir \
	--with-wx=%prefix \
	--with-wx-config=%_bindir/wx-config \
	--with-vorbis=%prefix \
	--with-fftw=%prefix \
	--with-sdl=%prefix \
	--with-gl=%prefix

%make_build

%install
%makeinstall_std
%make_install DESTDIR="%buildroot/" install
install -pD -m644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -pD -m644 %SOURCE2 %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE4 %buildroot%_liconsdir/%name.png

%files
%_gamesbindir/scorched3d*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_desktopdir/%name.desktop
%doc AUTHORS README documentation/*

%files data
%_gamesdatadir/*

%changelog
