%ifarch %qt5_qtwebengine_arches
%def_enable qtwebengine
%else
%def_disable qtwebengine
%endif

Name: seadrive-gui
Version: 2.0.19
Release: alt2.1

Summary: Seafile Drive client

Group: Networking/File transfer
License: Apache License
Url: https://github.com/haiwen/seadrive-gui

# Source-url: https://github.com/haiwen/seadrive-gui/archive/v%version.tar.gz
Source: %name-%version.tar

# TODO: is not opensourced
#Requires: seadrive-daemon >= 1.0.0

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-qt5-webengine

BuildRequires: cmake libsqlite3-devel libssl-devel zlib-devel libcurl-devel
BuildRequires: qt5-imageformats qt5-tools-devel qt5-base-devel

BuildRequires: libevent-devel >= 2.0
BuildRequires: libglib2-devel libuuid-devel libjansson-devel
BuildRequires: libsearpc-devel

%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%else
BuildRequires: qt5-webkit-devel
%endif

%description
Seafile Drive client.
Seafile is an open source cloud storage system with features
on privacy protection and teamwork. Collections of files are
called libraries, and each library can be synced separately.
A library can also be encrypted with a user chosen password.
Seafile also allows users to create groups and easily sharing
files into groups.

Note: you need install seadrive-daemon also, which not opensourced.

%prep
%setup
sed -i '1iADD_DEFINITIONS(-DGLIB_VERSION_MIN_REQUIRED=GLIB_VERSION_2_26)' CMakeLists.txt
%if_disabled qtwebengine
sed -i '/USE_QT_WEBKIT/ {s/OFF/ON/}' CMakeLists.txt
%endif

%build
PATH=%_qt5_bindir:$PATH %cmake_insource
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/seadrive-gui
%_desktopdir/seadrive.desktop
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*

%changelog
