%def_enable snapshot
%define _name seahorse
%define ver_major 3.11
%define ext_api_ver 4
%define nautilus_extdir %_libdir/nautilus/extensions-%ext_api_ver

%def_enable libnotify

Name: %_name-nautilus
Version: %ver_major.92
Release: alt4

Summary: PGP encryption and signing for Nautilus
License: LGPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Seahorse

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: %name-3.11.92-alt-gnupg-2.4.patch

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson
BuildRequires: libgtk+3-devel pkgconfig(libnautilus-extension-%ext_api_ver)
BuildRequires: libcryptui-devel libgpgme-devel
BuildRequires: libgnome-keyring-devel libdbus-glib-devel gnupg2-gpg gcr-libs-devel
%{?_enable_libnotify:BuildRequires: libnotify-devel >= 0.7.2}

%description
This package provides extension for Nautilus which allows encryption
and decryption of OpenPGP files using GnuPG.

%prep
%setup
%patch -b .gnupg

%build
%meson \
    %{?_enable_libnotify:-Dlibnotify=true}
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%_name-tool
%nautilus_extdir/libnautilus-seahorse.so
%_desktopdir/seahorse-pgp-encrypted.desktop
%_desktopdir/seahorse-pgp-keys.desktop
%_desktopdir/seahorse-pgp-signature.desktop
%_datadir/glib-2.0/schemas/org.gnome.seahorse.nautilus.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.seahorse.nautilus.window.gschema.xml
%_man1dir/%_name-tool.1.*
%doc AUTHORS NEWS README*

%changelog
