%define _unpackaged_files_terminate_build 1
%define _libexecdir /usr/libexec

Name: shorewall-lite
Version: 5.2.8
Release: alt2
Summary: Shoreline Firewall Lite is an iptables-based firewall for Linux systems.
License: GPLv2
Group: Security/Networking
Url: http://www.shorewall.net/
Source: %name-%version.tar.bz2
Source3: %name-control

BuildArch: noarch
Requires: shorewall-core
Provides: shoreline_firewall = %version-%release

BuildRequires: perl-Digest-SHA

%description
The Shoreline Firewall, more commonly known as "Shorewall", is a Netfilter
(iptables) based firewall that can be used on a dedicated firewall system,
a multi-function gateway/ router/server or on a standalone GNU/Linux system.

Shorewall Lite is a companion product to Shorewall that allows network
administrators to centralize the configuration of Shorewall-based firewalls.


%prep
%setup -n %name-%version
sed -i "s|SERVICEDIR=/lib/systemd/system|SERVICEDIR=%_unitdir|g" shorewallrc.alt

%build
%install
./configure.pl --host=%_vendor \
               --prefix=%prefix \
               --perllibdir=%perl_vendorlib \
               --libexecdir=%_libexecdir \
               --sbindir=%_sbindir

DESTDIR=%buildroot ./install.sh

install -D -m 0755 %SOURCE3 %buildroot%_controldir/%name

%post
%post_service %name

%preun
%preun_service %name

%files
%doc COPYING changelog.txt releasenotes.txt
%_sbindir/%name
%_initdir/%name
%_unitdir/*.service
%dir %_sysconfdir/%name
%attr(0644,root,root) %config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_logrotatedir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%_controldir/%name
%dir %_datadir/%name
%_datadir/%name/*
%dir %_localstatedir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/*
%_man5dir/*
%_man8dir/*

%changelog
