# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define _vstring %(echo %{version} |tr -d ".")

Name: shotcut
Version: 25.08.16
Release: alt1
Summary: A free, open source, cross-platform video editor
Summary(ru_RU.UTF-8): Свободный кросс-платформенный видеоредактор
License: GPL-3.0-or-later
Group: Video
Url: https://www.shotcut.org
VCS: https://github.com/mltframework/shotcut.git

ExcludeArch: armh

Source: %name-%version.tar

BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: pkgconfig(Qt6Charts)
BuildRequires: pkgconfig(Qt6Concurrent)
BuildRequires: pkgconfig(Qt6Core)
BuildRequires: pkgconfig(Qt6Gui)
BuildRequires: pkgconfig(Qt6Qml)
BuildRequires: pkgconfig(Qt6Multimedia)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6OpenGL)
BuildRequires: pkgconfig(Qt6PrintSupport)
BuildRequires: pkgconfig(Qt6Quick)
BuildRequires: pkgconfig(Qt6WebSockets)
BuildRequires: pkgconfig(Qt6Xml)
BuildRequires: pkgconfig(Qt6Sql)
BuildRequires: pkgconfig(Qt6UiTools)
BuildRequires: qt6-linguist
BuildRequires: mlt7xx-devel
BuildRequires: pkgconfig(mlt-framework-7)
BuildRequires: libx264-devel
BuildRequires: pkgconfig(sdl2)
BuildRequires: ImageMagick-tools
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-tools-devel
BuildRequires: qt6-imageformats
BuildRequires: libfftw3-devel

Requires: %name-data = %version
Requires: mlt-utils
Requires: gst-plugins-bad1.0
Requires: frei0r-plugins
Requires: ladspa_sdk
Requires: lame
Requires: ffmpeg ffprobe ffplay
Requires: libSDL2
# see bug 34876
Requires: libqt6-quickcontrols2
# see bug 34877
Requires: qt6-5compat
# Needed for timeline
Requires: libqt6-sql qt6-declarative

Provides: %name-data = %EVR
Obsoletes: %name-data < %EVR

%description
These are all currently implemented features:
 * supports oodles of audio and video formats and codecs;
 * supports many image formats as image sequences;
 * no import required - native editing;
 * frame-accurate seeking for many formats;
 * multi-format timeline;
 * screen capture (Linux only) including background capture;
 * webcam capture (Linux only);
 * audio capture (Linux only; PulseAudio, JACK, or ALSA);
 * network stream playback (HTTP, HLS, RTMP, RTSP, MMS, UDP);
 * frei0r video generator plugins (e.g. color bars and plasma);
 * Blackmagic Design SDI and HDMI for input and preview monitoring;
 * JACK transport sync;
 * deinterlacing;
 * detailed media properties panel;
 * recent files panel with search;
 * drag-n-drop files from file manager;
 * save and load trimmed clip as MLT XML file;
 * load and play complex MLT XML file as a clip;
 * audio signal level meter;
 * volume control;
 * scrubbing and transport control;
 * flexible UI through dock-able panels;
 * encode/transcode to a variety of formats and codecs;
 * capture (record);
 * stream (encode to IP) files and any capture source;
 * batch encoding with job control;
 * MLT XML playlists;
 * unlimited undo and redo for playlist edits;
 * connect to Melted servers over MVCP TCP protocol;
 * control the transport playback of Melted units;
 * edit Melted playlists including support for undo/redo;
 * OpenGL GPU-based image processing;
 * multi-core parallel image processing when not using GPU;
 * video filters;
 * audio filters;
 * 3-way color wheels for color correction and grading;
 * eye dropper tool to pick neutral color for white balancing;
 * HTML5 (sans audio and video) as video source and filters;
 * Leap Motion for jog/shuttle control;
 * DeckLink SDI keyer output - internal or external;
 * UI themes/skins: native-OS look and custom dark and light;
 * control video zoom in the player.

%prep
%setup

%ifarch %e2k
sed -i '/ createIndex([^,()]*, [^,()]*, (int)0);$/s/(int)0/(quintptr)0/' \
  src/models/{actions,alignclips,markers,resource}model.cpp
%endif

# Postmortem debugging tools for MinGW.
rm -rf drmingw

%build
%cmake -DCMAKE_INSTALL_LIBDIR=%_lib \
       -DSHOTCUT_VERSION="%version"
%cmake_build

%install
%cmake_install
chmod a+x %buildroot/%_datadir/shotcut/qml/export-edl/rebuild.sh

for i in 16 32 48; do
    mkdir -p %buildroot/%_iconsdir/hicolor/"$i"x"$i"/apps
    convert icons/%name-logo-64.png -resize "$i"x"$i" \
    %buildroot/%_iconsdir/hicolor/"$i"x"$i"/apps/org.shotcut.Shotcut.png
done

%files
%doc COPYING README.md
%_bindir/%name
%_libdir/*.so*
%_datadir/%name
%_desktopdir/org.shotcut.Shotcut.desktop
%_iconsdir/hicolor/*/apps/org.shotcut.Shotcut.png
%_datadir/mime/packages/org.shotcut.Shotcut.xml
%_datadir/metainfo/org.shotcut.Shotcut.metainfo.xml
%_man1dir/*

%changelog
