Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: maven-local
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with bootstrap

Name:           sisu
Epoch:          2
Version:        0.3.5
Release:        alt1_2jpp11
Summary:        Eclipse dependency injection framework
# sisu is EPL-1.0, the bundled asm is BSD
License:        EPL-1.0 and BSD
URL:            https://eclipse.org/sisu/
BuildArch:      noarch

Source0:        https://github.com/eclipse/sisu.inject/archive/refs/tags/releases/%{version}.tar.gz#/org.eclipse.sisu.inject-%{version}.tar.gz
Source1:        https://github.com/eclipse/sisu.plexus/archive/refs/tags/releases/%{version}.tar.gz#/org.eclipse.sisu.plexus-%{version}.tar.gz

Source100:      sisu-parent.pom
Source101:      sisu-inject.pom
Source102:      sisu-plexus.pom

Patch0:         sisu-OSGi-import-guava.patch
Patch2:         sisu-ignored-tests.patch
Patch3:         sisu-osgi-api.patch
Patch4:         0001-Remove-dependency-on-glassfish-servlet-api.patch

%if %{with bootstrap}
BuildRequires:  javapackages-bootstrap
%else
BuildRequires:  maven-local
BuildRequires:  mvn(com.google.inject.extensions:guice-servlet)
BuildRequires:  mvn(com.google.inject:guice::no_aop:)
BuildRequires:  mvn(javax.annotation:javax.annotation-api)
BuildRequires:  mvn(javax.enterprise:cdi-api)
BuildRequires:  mvn(javax.inject:javax.inject)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.codehaus.plexus:plexus-classworlds)
BuildRequires:  mvn(org.codehaus.plexus:plexus-component-annotations)
BuildRequires:  mvn(org.codehaus.plexus:plexus-utils)
BuildRequires:  mvn(org.osgi:osgi.core)
BuildRequires:  mvn(org.slf4j:slf4j-api)
BuildRequires:  mvn(org.testng:testng)
%endif

Provides:       %{name}-inject = %{epoch}:%{version}-%{release}
Provides:       %{name}-plexus = %{epoch}:%{version}-%{release}
Provides:       bundled(objectweb-asm)
Source44: import.info

Obsoletes:      %{name}-inject < 1:0.3.4-alt1_6
Conflicts:      %{name}-inject < 1:0.3.4-alt1_6
Obsoletes:      %{name}-plexus < 1:0.3.4-alt1_6
Conflicts:      %{name}-plexus < 1:0.3.4-alt1_6

%description
Java dependency injection framework with backward support for plexus and bean
style dependency injection.

%{?javadoc_package}

%prep
%setup -q -c -T
tar xf %{SOURCE0} && mv sisu.inject-releases-* sisu-inject
tar xf %{SOURCE1} && mv sisu.plexus-releases-* sisu-plexus

cp %{SOURCE100} pom.xml
cp %{SOURCE101} sisu-inject/pom.xml
cp %{SOURCE102} sisu-plexus/pom.xml

%patch0
%patch2
%patch3
%patch4 -p1

%pom_remove_dep :servlet-api sisu-inject

%pom_xpath_set -r /pom:project/pom:version %{version}

%mvn_file ":{*}" @1
%mvn_package ":*{inject,plexus}"
%mvn_package : __noinstall
%mvn_alias :org.eclipse.sisu.plexus org.sonatype.sisu:sisu-inject-plexus

%build
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference sisu-inject/LICENSE.txt

%changelog
