Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global         githash     1ca80982c5a32c82bfc5e98e1fe9d8751ab44946
%global         shorthash   %(TMP=%githash ; echo ${TMP:0:10})
%global         gitdate     Wed, 17 Feb 2021 00:09:15 +0900
%global         gitdate_num 20210217

%global         githash_tools     0fe2106fbc052445c611e6c5b2a79899d740edcb

%undefine        _changelog_trimtime

Summary:	Dictionaries for SKK (Simple Kana-Kanji conversion program)
Name:		skkdic
Version:	%{gitdate_num}
Release:	alt1_3.git1ca80982c5
# See Source2
License:	GPLv2+ and CC-BY-SA and Unicode and Public Domain and MIT

Source0:	https://github.com/skk-dev/dict/archive/%{githash}/%{name}-%{gitdate_num}.git%{githash}.tar.gz
Source1:	https://raw.githubusercontent.com/skk-dev/skktools/%{githash_tools}/unannotation.awk
Source2:	license-investigation.txt
Source200:	README-skkdic.rh.ja

URL:		https://skk-dev.github.io/dict/
BuildArch:	noarch
Source44: import.info


%description
This package includes the SKK dictionaries, including the large dictionary
SKK-JISYO.L and pubdic+ dictionary.

%prep
%setup -q -c -T -a 0
ln -sf dict-%{githash} src
mkdir tools

cp -p %SOURCE200 .
cp -p %SOURCE1 tools

pushd src
cp -a zipcode/README.md zipcode/README-zipcode.md
popd

%build
pushd src

for dic in \
	SKK-JISYO.L.unannotated \
	SKK-JISYO.wrong
do
	rm -f $dic
	make $dic
done

popd

%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/skk

pushd src
for f in SKK-JISYO* zipcode/SKK-JISYO*
do
	install -p -m 644 $f $RPM_BUILD_ROOT%{_datadir}/skk
done
gzip -9 ChangeLog

popd

%files
%doc	src/ChangeLog.gz
%doc	README-skkdic.rh.ja
%doc	src/committers.md
%doc	src/edict_doc.html
%doc	src/zipcode/README-zipcode.md

%{_datadir}/skk/

%changelog
