Summary: Tools for the multicast tests (ASM or SSM)
Name: smjoin
Version: 0.31
Release: alt1
License: BSD-like
Group: Networking/Other
Packager: Evgenii Terechkov <evg@altlinux.org>
Url: http://sasm3.net/SMJOIN/
Source0: %name/%name-%version.tar.gz

%description
The smjoin package includes
smclock/smjoin/smclock6/smjoin6/smsnd6/smrec6.

smclock/smjoin are tools for the IPv4 multicast sending and receiving
tests for ASM (Any Source Multicast) and SSM (Specific Source
Multicast).

smclock6/smjoin6 are tools for the IPv6 multicast sending and
receiving tests for ASM (Any Source Multicast) and SSM (Specific
Source Multicast).

smsnd6/smrec6 are tools for sending and receiving short text messages
in IPv6 multicast environment.

%prep
%setup

%build
cd smjoin
make %{?_smp_mflags} CFLAGS="%optflags" smclock smjoin
cd ../smjoin6
make %{?_smp_mflags} CFLAGS="%optflags" smclock6 smjoin6
cd ../smrec6
make %{?_smp_mflags} CFLAGS="%optflags" smsnd6 smrec6

%install
for i in smjoin/smjoin smjoin/smclock smrec6/smrec6 smrec6/smsnd6 smjoin6/smjoin6 smjoin6/smclock6
do
install -pD -m755 $i %buildroot%_bindir/`basename $i`
done

cat >> README <<EOF
Introduction
The smjoin package includes smclock/smjoin/smclock6/smjoin6/smsnd6/smrec6.

smclock/smjoin are tools for the IPv4 multicast sending and receiving
tests for ASM (Any Source Multicast) and SSM (Specific Source
Multicast).

smclock6/smjoin6 are tools for the IPv6 multicast sending and
receiving tests for ASM (Any Source Multicast) and SSM (Specific
Source Multicast).

smsnd6/smrec6 are tools for sending and receiving short text messages
in IPv6 multicast environment.

How it works smclock/smclock6 send text strings containing
date-and-time generated by system clock every seconds to a specific
multicast group or channel. smjoin/smjoin6 can join the corresponding
group (*, G) or channel (S, G) to receive the text strings and report
the related information. (Note taht smjoin/smjoin6 can join multicast
group or channel generated by any multicast application.)

smsnd6/smrec6 are similar to smclock6/smjoin6, but the text strings
are read from a text file and the strings are displayed in the stdout.

smclock/smjoin/smclock6/smjoin6/smsnd6/smrec6 are handy tools to check
the multicast support of the network.

Usage

smclock 233.17.186.20 [-p 10002] [-ttl 10] [-sec 10] [-u]
parameter description
233.17.186.20 		group address = 233.17.186.20 (can also be unicast address)
-p 10002		port number = 10002
-ttl 10			time to live = 10 hops
-sec 10			execution time = 10 seconds (-1 for infinit loop)
-u			set accuracy in microseconds

smjoin 233.17.186.20 [-s 162.105.196.100] [-p 1700] [-raw] [-c 10] [-k 1000]
parameter description
233.17.186.20 		group address = 233.17.186.20 (can also be unicast address)
-s 162.105.196.100	source address = 162.105.196.100 (in case of SSM)
-p 1700			port number = 1700
-raw			print received packets in stdout
-c 10			exit when receive 10 packets (-1 for infinit loop)
-k 1000			report information when receive 1000 packets

smclock6 2001:250:ccce:: [-p 10002] [-ttl 10] [-sec 10] [-s 2001:da8:aaae::6] [-u]
parameter description
2001:250:ccce:: 	group address = 2001:250:ccce:: (can also be unicast address)
-p 10002		port number = 10002
-ttl 10			time to live = 10 hops
-s 2001:da8:aaae::6	source address = 2001:da8:aaae::6 (case of multiple address)
-sec 10			execution time = 10 seconds (-1 for infinit loop)
-u			set accuracy in microseconds

smjoin ff3e::1234:4321 [-s 2001:250:ccce::] [-p 1700] [-raw] [-c 10] [-k 1000] 
parameter description
ff3e::1234:4321 	group address = ff3e::1234:4321 (can also be unicast address)
-s 2001:250:ccce::	source address = 2001:250:ccce:: (in case of SSM)
-p 1700			port number = 1700
-raw			print received packets in stdout
-c 10			exit when receive 10 packets (-1 for infinit loop)
-k 1000			report information when receive 1000 packets

smsnd6 2001:250:ccce:: [-p 10002] [-ttl 10] [-sec 10] [-s 2001:da8:aaae::6] [-u] [-sleep 3]
parameter description
2001:250:ccce:: 	group address = 2001:250:ccce:: (can also be unicast address)
-p 10002		port number = 10002
-ttl 10			time to live = 10 hops
-sec 10			execution time = 10 seconds
-s 2001:da8:aaae::6	source address = 2001:da8:aaae::6 (case of multiple address)
-sleep 3		pause in every 3 seconds when reach a \n in the text file read in stdin

smrec6 ff3e::1234:4321 [-s 2001:250:ccce::] [-p 1700] [-c 10]
parameter description
ff3e::1234:4321 	group address = ff3e::1234:4321 (can also be unicast address)
-s 2001:250:ccce::	source address = 2001:250:ccce:: (in case of SSM)
-p 1700			port number = 1700
-raw			print received packets in stdout (must given)
-c 10			exit when receive 10 packets (must be -1)

Examples

%% smjoin 233.17.186.236 -p 10002
ASM: 219.243.252.170#10002 [233.17.186.236#10002] 12 bytes MSG (1)
ASM: 219.243.225.162#10002 [233.17.186.236#10002] 12 bytes MSG (2)
ASM: 219.243.224.178#10002 [233.17.186.236#10002] 12 bytes MSG (3)
ASM: 219.243.224.162#10002 [233.17.186.236#10002] 12 bytes MSG (4)
ASM: 219.243.240.162#10002 [233.17.186.236#10002] 12 bytes MSG (5)
ASM: 219.243.227.162#10002 [233.17.186.236#10002] 12 bytes MSG (6)
ASM: 219.243.230.162#10002 [233.17.186.236#10002] 6 bytes MSG (7)
ASM: 219.243.226.162#10002 [233.17.186.236#10002] 12 bytes MSG (8)
ASM: 219.243.250.162#10002 [233.17.186.236#10002] 6 bytes MSG (9)
ASM: 219.243.253.162#10002 [233.17.186.236#10002] 12 bytes MSG (10)

%% smjoin6 ff3e::1 -p 1500 -s 2001:da8:ff:101::2
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (0)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (1)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (2)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (3)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (4)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (5)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (6)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (7)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (8)
SSM: [2001:da8:ff:101::2]#33099 [ff3e::1]#1500 31 bytes MSG (9)

Credits

Design and coding: 
  Xing Li <xing@cernet.edu.cn>
  Congxiao Bao <congxiao@cernet.edu.cn>

Contributions:
  Some portions of the code are copied and modified from 
    mcastClient.c fpont 12/99 pont.net 
    ssmping package * Copyright (C) 2005  Stig Venaas 

License
See top of the individual source files.
Bugs/feedback

We would be happy for any feedback.
   sasm3.adm@gmail.com

EOF

%files
%_bindir/*
%doc README smrec6/chinese-poems.txt

%changelog
