%define pname Mail-SpamAssassin

# build spamc with SSL support enabled?
%def_enable ssl

Name: spamassassin
Version: 4.0.2
Release: alt1

Summary: Spam filter for email written in perl
License: Apache-2.0
Group: Networking/Mail

URL: http://www.spamassassin.org/
Source0: https://dlcdn.apache.org//spamassassin/source/%{pname}-%{version}.tar.bz2
Source1: spamd.init
Source2: spamassassin_local.cf
Source3: spamd.sysconfig
Source4: spamd.service

# from Debian:
Patch10: spamassassin-deb-10_change_config_paths.patch
Patch11: spamassassin-deb-20_edit_spamc_pod.patch
Patch12: spamassassin-deb-55_disable_nagios_epm.patch
Patch13: spamassassin-deb-90_pod_cleanup.patch

# upstream fixes

%def_without test
# normal method nukes on errors :(
%define _perl_req_method relaxed

%{?_enable_ssl:BuildRequires: libssl-devel}

# Automatically added by buildreq on Thu Jul 21 2011
# optimized out: libcom_err-devel libkrb5-devel perl-Compress-Raw-Bzip2 perl-Compress-Raw-Zlib perl-Digest-SHA perl-Digest-SHA1 perl-Encode perl-Error perl-HTML-Parser perl-HTTP-Date perl-HTTP-Message perl-IO-Compress perl-IO-Socket-INET6 perl-IO-String perl-IO-Zlib perl-Net-DNS perl-Net-SSLeay perl-NetAddr-IP perl-Package-Constants perl-Pod-Escapes perl-Pod-Parser perl-Pod-Simple perl-Socket6 perl-URI perl-libnet perl-podlators
BuildRequires: perl-Archive-Tar perl-DBI perl-DBM perl-Encode-Detect perl-IO-Socket-SSL perl-IP-Country perl-Mail-DKIM perl-Mail-SPF perl-Razor perl-devel perl-libwww zlib-devel perl(Pod/Man.pm)

# Was needed by sa-stats from tools/ (currently not shipped in tarball so)
BuildRequires: perl-Parse-Syslog

# Optimized out, but let them be on list (to reassure they will not drop out in future)
BuildRequires: perl-Net-DNS
BuildRequires: perl-HTML-Parser

BuildRequires: perl-BSD-Resource perl-TermReadKey

Requires: perl-%pname = %version-%release

# Versioned requires for sa-update (see INSTALL in sources for required versions):
Requires: perl-IO-Zlib >= 1.04
Requires: perl-Archive-Tar >= 1.23

# I doubt this is sensible, Ident protocol is pointless, potentially dangerous
# and ineffective for spamassassin:
# BuildRequires: perl-Net-Ident

%description
SpamAssassin provides you with a way to reduce if not completely eliminate
Unsolicited Commercial Email (SPAM) from your incoming email. It can be
invoked by a MTA such as exim or postfix, or can be called from a procmail
script, .forward file, etc. It uses a genetic-algorithm evolved scoring
system to identify messages which look spammy, then adds headers to the
message so they can be filtered by the user's mail reading software.

%package spamd
Summary: spamd - daemonized version of spamassassin
Group: Networking/Mail
BuildArch: noarch

Requires: perl-%pname = %version-%release

# To synchronize spamd and spamc version if they installed both:
Requires: %name-version = %version-%release

# Not autodetected by rpm, needed for spamc/spamd SSL communication:
Requires: perl-IO-Socket-SSL

Requires(pre): shadow-utils
Requires(post): %post_service
Requires(preun): %preun_service

%description spamd
The purpose of this program is to provide a daemonized version of the
spamassassin executable. The goal is improving throughput performance
for automated mail checking.

This is intended to be used alongside "spamc", a fast, low-overhead C
client program.

%package spamc
Summary: spamc - client for spamd
Group: Networking/Mail
Requires(post): shadow-utils

# To synchronize spamd and spamc version if they installed both:
Requires: %name-version = %version-%release

%description spamc
Spamc is the client half of the spamc/spamd pair. It should be used in place
of "spamassassin" in scripts to process mail. It will read the mail from
STDIN, and spool it to its connection to spamd, then read the result back and
print it to STDOUT. Spamc has extremely low overhead in loading, so it should
be much faster to load than the whole spamassassin program.

%package -n perl-%pname
Summary: Mail::SpamAssassin - SpamAssassin e-mail filter libraries
Group: Development/Perl
BuildArch: noarch

# Non-autodetectable (usually due to eval'ed using) deps listed below:
Requires: perl-Net-DNS
# Needed by SPF plugin
Requires: perl-Mail-SPF
# Needed by RelayCountry plugin
Requires: perl-IP-Country
# Needed by DKIM plugin
Requires: perl-Mail-DKIM

# Since 3.3.0 upstream ships spamassassin rules separately
Requires: spamassassin-rules = %version

# Versioned requires:
Requires: perl-HTML-Parser >= 3.46

%description -n perl-%pname
Mail::SpamAssassin is a Mail::Audit plugin to identify spam using text
analysis and several internet-based realtime blacklists. Using its rule
base, it uses a wide range of heuristic tests on mail headers and body
text to identify ``spam'', also known as unsolicited commercial email.
Once identified, the mail can then be optionally tagged as spam for
later filtering using the user's own mail user-agent application.

%package version
Summary: Empty package to synchronize other spamassassin subpackages versions with
Group: Networking/Mail
BuildArch: noarch

%description version
This package contains no files and exist just to synchronize other spamassassin
subpackages versions with.

%prep
%setup -q -n Mail-SpamAssassin-%{version}
%patch10 -p2
%patch11 -p1
%patch12 -p1
%patch13 -p1

%build
cp -f spamc/spamc.pod spamc/spamc
%perl_vendor_build LOCALRULESDIR=%_sysconfdir/spamassassin INSTALLMAN1DIR=%_man1dir BUILD_SPAMC=no

# Rebuild spamc with SSL
pushd spamc
%autoreconf
%configure \
	--sysconfdir=%_sysconfdir/spamassassin \
	--datadir=%_datadir/spamassassin \
	%{subst_enable ssl}
popd
rm -f spamc/spamc
%make_build blib/script/spamc

%install
mkdir -p %buildroot{/var/spool/spamassassin,%_localstatedir/spamd,/var/run/spamd,/var/lib/spamassassin}

%perl_vendor_install \
	SYSCONFDIR=%buildroot%_sysconfdir \
	B_CONFDIR=%buildroot%_sysconfdir/spamassassin \
	I_CONF_DIR=%buildroot%_sysconfdir/spamassassin \
	B_DATADIR=%buildroot%_datadir/spamassassin \
	install

find %buildroot -name .svn -exec rm -rf -- {} \;

install -pD -m755 %SOURCE1 %buildroot%_initdir/spamd
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/spamassassin/local.cf
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/spamd
install -pD -m644 %SOURCE4 %buildroot%_unitdir/spamd.service

install -d -m700 %buildroot%_sysconfdir/spamassassin/sa-update-keys

# NO! We don't want dependancy on PostgreSQL generated by findreq from this file:
%add_findreq_skiplist %perl_vendor_privlib/Mail/SpamAssassin/BayesStore/PgSQL.pm

pod2man spamc/spamc.pod %buildroot%_man1dir/spamc.1

install -d %buildroot%_sysconfdir/cron.d
cat <<EOF >%buildroot%_sysconfdir/cron.d/sa-update
# you can switch "space" to "tab" between minutes and hours
# for stop randomization when when spamassasin installing
30 01 * * *    root    %_bindir/sa-update && ( service spamd status >/dev/null 2>&1 && service spamd condrestart >/dev/null )
EOF

#warning: Installed (but unpackaged) file(s) found:
#    /usr/lib/perl5/perllocal.pod
rm -f %buildroot%perl_vendor_archlib/perllocal.pod

%post
# randomize time of sa rules updating
RNDM1=$[$RANDOM/555]   # 0-59
RNDM2=$[$RANDOM/1424]  # 0-23
sed "s/^[0-9]\+ \+[0-9]\+/$RNDM1 $RNDM2/" -i %_sysconfdir/cron.d/sa-update >/dev/null 2>&1 ||:

%post spamd
%post_service spamd

%preun spamd
%preun_service spamd

%post spamc
/usr/sbin/groupadd -r -f spamd
/usr/sbin/useradd -r -g spamd -d /dev/null -s /dev/null -N spamc >/dev/null 2>&1 ||:

%pre spamd
/usr/sbin/groupadd -r -f spamd
/usr/sbin/useradd -r -g spamd -d %_localstatedir/spamd -s /dev/null -N spamd >/dev/null 2>&1 ||:

%files
%doc CREDITS INSTALL README TRADEMARK USAGE procmailrc.example Changes sample-nonspam.txt sample-spam.txt
%doc ldap sql
%_bindir/spamassassin
%_bindir/sa-awl
%_bindir/sa-compile
%_bindir/sa-learn
%_bindir/sa-update

%config(noreplace) %_sysconfdir/cron.d/sa-update
%_man1dir/spamassassin*
%_man1dir/sa-compile*
%_man1dir/sa-learn*
%_man1dir/sa-update*
%_man1dir/sa-awl*
# sa-update download rules to /var/lib/spamassassin, so both should be in one subpackage:
%dir /var/lib/spamassassin

%files version

%files spamd
%doc spamd/README spamd/PROTOCOL
%config %_initdir/spamd
%config %_unitdir/spamd.service
%config(noreplace) %_sysconfdir/sysconfig/spamd
%_bindir/spamd
%_bindir/sa-check_spamd
%_man1dir/spamd*
%attr(700,spamd,spamd) %_localstatedir/spamd/
#attr(3770,root,spamd) /var/run/spamd/

%files spamc
%_bindir/spamc
%_man1dir/spamc*

%files -n perl-%pname
%doc sample-nonspam.txt sample-spam.txt
%dir %_sysconfdir/spamassassin
%dir %attr(0700,root,root) %_sysconfdir/spamassassin/sa-update-keys
%config(noreplace) %_sysconfdir/spamassassin/*.*
%_datadir/spamassassin
%dir %attr(0775,root,mail) /var/spool/spamassassin
%perl_vendor_privlib/Mail
%perl_vendor_privlib/spamassassin-run.pod
#%_man3dir/*

%changelog
