%def_disable static


Name: sqlite3
Version: 3.50.4
Release: alt1
Summary: An Embeddable SQL Database Engine
License: ALT-Public-Domain
Group: Development/Databases
Packager: Denis Medvedev <nbr@altlinux.org>
URL: http://www.sqlite.org/

Source0: sqlite-%version.tar
Source1: sqlite3.watch

Patch2: 0002-FEDORA-percentile-test.patch
Patch3: 0003-FEDORA-ALT-datetest-2.2c.patch
Patch5: 0005-ALT-run-func7-pg-181-test-only-on-x86_64.patch

BuildRequires(Pre): tcl-devel
BuildRequires: libreadline-devel
# need for test
BuildRequires: zlib-devel unzip

%define _unpackaged_files_terminate_build 1

%description
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lib%name
Summary: An Embeddable SQL Database Engine (shared library)
Group: System/Libraries
Provides: sqlite(SECURE_DELETE) sqlite(COLUMN_METADATA) sqlite(FTS3) sqlite(UNLOCK_NOTIFY)
Provides: %name-fts3 = %version-%release
Obsoletes: %name-fts3 < %version-%release

%description -n lib%name
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lib%name-devel
Summary: An Embeddable SQL Database Engine (header files)
Group: Development/Databases
Requires: lib%name = %version-%release

%description -n lib%name-devel
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lib%name-devel-static
Summary: An Embeddable SQL Database Engine (static library)
Group: Development/Databases
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n tcl-sqlite3
Summary: An Embeddable SQL Database Engine (TCL bindings)
Group: Development/Tcl
Provides: sqlite3-tcl = %version
Obsoletes: sqlite3-tcl < %version

%description -n tcl-sqlite3
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package doc
Summary: An Embeddable SQL Database Engine (documentation)
Group: Development/Documentation
Conflicts: %name < 3.3.8-alt1
BuildArch: noarch

%description doc
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lemon
Summary: The Lemon Parser Generator
Group: Development/Other

%description -n lemon
Lemon is an LALR(1) parser generator for C or C++. It does the same
job as bison and yacc. But lemon is not another bison or yacc
clone. It uses a different grammar syntax which is designed to reduce
the number of coding errors. Lemon also uses a more sophisticated
parsing engine that is faster than yacc and bison and which is both
reentrant and thread-safe. Furthermore, Lemon implements features
that can be used to eliminate resource leaks, making is suitable for
use in long-running programs such as graphical user interfaces or
embedded controllers.

%prep
%setup -q -n sqlite-%version
%autopatch -p2

%build
export TCLLIBDIR=%_tcllibdir
export TCLDATADIR=%_tcldatadir/%name
export CFLAGS="%optflags \
	-DSQLITE_CORE \
	-DSQLITE_ENABLE_API_ARMOR \
	-DSQLITE_ENABLE_COLUMN_METADATA \
	-DSQLITE_ENABLE_DBSTAT_VTAB \
	-DSQLITE_ENABLE_DESERIALIZE \
	-DSQLITE_ENABLE_UPDATE_DELETE_LIMIT \
	-DSQLITE_ENABLE_FTS3 \
	-DSQLITE_ENABLE_FTS3_PARENTHESIS \
	-DSQLITE_ENABLE_FTS4 \
	-DSQLITE_ENABLE_FTS5 \
	-DSQLITE_ENABLE_RTREE \
	-DSQLITE_ENABLE_UNLOCK_NOTIFY \
	-DSQLITE_SECURE_DELETE \
	-fno-strict-aliasing "
%ifarch %e2k
# FIXME: lcc-1.23 lacks some gcc5 builtins
cc --version | grep -q '^lcc:1.21' || export CFLAGS+="-D__INTEL_COMPILER=1"
%endif

%tea_patch
%undefine _configure_gettext  
%configure \
	%{subst_enable static} \
	--disable-amalgamation \
	--enable-all \
	--enable-fts3 \
	--enable-fts4 \
	--enable-fts5 \
	--enable-load-extension \
	--enable-readline \
	--enable-rtree \
	--enable-threadsafe \
	--soname=legacy
	#

env  LDFLAGS.rpath="" make -e all sqlite3_analyzer sqldiff

%check
sed -Ei 's@-DSQLITE_ENABLE_FTS[345](\s|$)@@g' Makefile
export LD_LIBRARY_PATH=%buildroot%_libdir
%make test

%install
%make_install install  DESTDIR=%buildroot

# move to the place according to ALT TEA policy
mkdir -p %buildroot%_libdir/tcl/sqlite3
mv %buildroot/%_tcllibdir/pkgIndex.tcl  %buildroot%_tcllibdir/sqlite3 
sed -Ei 's/dir/dir \.\. /' %buildroot%_tcllibdir/sqlite3/pkgIndex.tcl


install -pD -m644 %name.1 %buildroot%_man1dir/%name.1

install -pD -m755 sqlite3_analyzer %buildroot%_bindir/sqlite3_analyzer
install -pD -m755 sqldiff %buildroot%_bindir/sqldiff

install -pD -m755 lemon %buildroot%_bindir/lemon
install -pD -m644 lempar.c %buildroot%_datadir/lemon/lempar.c

# for perl-DBD-SQLite, full text search engines
install -p -m644 ext/fts3/fts3.h ext/fts3/fts3_*.h %buildroot%_includedir/
install -p -m644 ext/fts5/fts5.h  %buildroot%_includedir/

%define pkgdocdir %_docdir/%name
mkdir -p %buildroot%pkgdocdir
cp -ar doc/* %buildroot%pkgdocdir/

%files
%_bindir/%name
%_bindir/sqlite3_analyzer
%_bindir/sqldiff
%_man1dir/%name.*

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/sqlite3.h
%_includedir/sqlite3ext.h
%_includedir/fts3.h
%_includedir/fts3_*.h
%_includedir/fts5.h
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif # static

%files -n tcl-sqlite3
%_tcllibdir/libtclsqlite3.so*
%_tcllibdir/sqlite3

%files doc
%pkgdocdir
%exclude %pkgdocdir/doc/lemon.html

%files -n lemon
%pkgdocdir/doc/lemon.html
%_bindir/lemon
%_datadir/lemon

%changelog
