%def_enable check
%def_disable bootstrap

%define rdn_name sm.puri.Squeekboard

Name: squeekboard
Version: 1.43.1
Release: alt1

Summary: A Wayland on-screen keyboard
License: GPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://gitlab.gnome.org/World/Phosh/squeekboard

Vcs: https://gitlab.gnome.org/World/Phosh/squeekboard.git

Source0: %name-%version.tar
Source1: %name-%version-crates.tar
Patch3500: squeekboard-1.23-alt-nix-loongarch64.patch

Provides: osk-wayland
Requires: dconf
# for %name-entry
Requires: typelib(Gtk) = 3.0
# for %name-entry4
Requires: typelib(Gtk) = 4.0

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-macros-alternatives
BuildRequires: meson rust-cargo /proc
BuildRequires: pkgconfig(libbsd)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(wayland-scanner)
BuildRequires: pkgconfig(gnome-desktop-3.0)
BuildRequires: pkgconfig(libfeedback-0.0)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: cargo-vendor-checksum diffstat
%{?_enable_check:BuildRequires: clippy xkeyboard-config}

%description
%summary

%prep
%setup
%if_enabled bootstrap
mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar cf %SOURCE1 vendor .cargo/config.toml
%else
tar xf %SOURCE1
%patch3500 -p1
diffstat -l -p1 %PATCH3500 | sed -re 's@vendor/@@' | xargs -r cargo-vendor-checksum -f
%endif

%build
%meson
%meson_build

%install
%meson_install

mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/osk-wayland	%_bindir/%name 90
EOF

%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_bindir/%name-entry
%_bindir/%name-test-layout
%_altdir/%name
%_desktopdir/*.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml

%changelog
