# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: sslscan
Version: 2.1.3
Release: alt1
Summary: sslscan tests SSL/TLS enabled services to discover supported cipher suites
License: GPL-3.0-or-later
Group: Security/Networking
Url: https://github.com/rbsec/sslscan

Source: %name-%version.tar
BuildRequires: libssl-devel
%{?!_without_check:%{?!_disable_check:BuildRequires: openssl}}

%description
%summary

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS) -fanalyzer -Werror -Wno-analyzer-malloc-leak
%make_build CFLAGS="%optflags" DEFINES=-DVERSION='\"%version-%release\"'

%install
%makeinstall_std

%check
%buildroot%_bindir/sslscan --version
openssl req -x509 -newkey rsa -keyout server.pem -out server.pem -days 1 -nodes -subj /CN=qwerty
openssl s_server &>/dev/null </dev/zero &
trap "kill $!" EXIT
sleep 1
%buildroot%_bindir/sslscan --no-colour --xml=a.xml 127.1:4433
grep -q -v error a.xml
grep -q accepted a.xml
grep -q qwerty   a.xml

%files
%doc LICENSE README.md
%_bindir/sslscan
%_man1dir/sslscan.1.xz

%changelog
