%def_disable clang
%def_without dlightdm

Name: startdde
Version: 6.0.14
Release: alt1
Epoch: 1
Summary: Starter of deepin desktop environment
License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/startdde
Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %url/archive/%version/%name-%version.tar.gz
Source1: vendor.tar

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): rpm-build-golang /proc
BuildRequires: jq glib2-devel libgio-devel libgtk+3-devel libXcursor-devel libXfixes-devel libXi-devel libgudev-devel libgnome-keyring-devel libpulseaudio-devel libalsa-devel libsecret-devel

%if_with dlightdm
Requires: deepin-session-shell
%endif

%description
Startdde is used for launching DDE components and invoking user's custom applications which compliant with xdg autostart specification.

%prep
%setup
# Unpacked vendor/ into the source (used .gear/tags).
tar -xf %SOURCE1

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
%endif
export GOPATH="$(pwd)/vendor:%go_path"
# export GO_BUILD_FLAGS=-trimpath
%make

%install
export GOPATH="%go_path"
%makeinstall DESTDIR=%buildroot
%if_without dlightdm
# conflict with system lightdm
rm -rf %buildroot%_datadir/lightdm/lightdm.conf.d/60-deepin.conf
%endif
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_sbindir/deepin-fix-xauthority-perm
%dir %_libexecdir/deepin-daemon/
%_libexecdir/deepin-daemon/greeter-display-daemon
%dir %_datadir/%name/
%_datadir/%name/filter.conf
%_datadir/glib-2.0/schemas/com.deepin.dde.display.gschema.xml
%_userunitdir/dde-display-task-refresh-brightness.service
%dir %_userunitdir/dde-session-initialized.target.wants/
%_userunitdir/dde-session-initialized.target.wants/dde-display-task-refresh-brightness.service
%if_with dlightdm
%_datadir/lightdm/lightdm.conf.d/60-deepin.conf
%endif

%changelog
