%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

Name: supertuxkart
Version: 1.4
Release: alt2

Summary: SuperTuxKart is a kart racing game

License: GPL-2.0-or-later and GPL-3.0-or-later and CC-BY-SA-3.0
Group: Games/Arcade
Url: http://supertuxkart.sourceforge.net

Packager: Ilya Mashkin <oddity@altlinux.ru>

# https://github.com/supertuxkart/stk-code
Source: %name-%version-src.tar.gz
Patch0: 0001-Add-missing-includes-to-fix-the-build-with-gcc-13.patch
Patch1: 0001-gcc13-fixes.patch

BuildRequires(pre): rpm-build-ninja
# for aarch64 support
BuildRequires(pre): libGLES
# Automatically added by buildreq on Thu Jan 30 2020 (-bi)
# optimized out: bash4 bashrc cmake-modules elfutils glibc-kernheaders-generic glibc-kernheaders-x86 libGLU-devel libICE-devel libSM-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libXrender-devel libcrypt-devel libglvnd-devel libharfbuzz-devel libogg-devel libsasl2-3 libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl pkg-config python-modules python2-base python3 python3-base rpm-build-gir sh4 tzdata wayland-devel xorg-proto-devel xorg-xf86miscproto-devel zlib-devel
BuildRequires: bzlib-devel cmake gcc-c++ libGLEW-devel libXi-devel libXrandr-devel libXt-devel libXxf86misc-devel libXxf86vm-devel libcurl-devel libfreetype-devel libfribidi-devel libjpeg-devel libopenal-devel libpng-devel libsqlite3-devel libssl-devel libvorbis-devel libwayland-cursor-devel libwayland-egl-devel libxkbcommon-devel libxkbfile-devel poppler rpm-build-python3 libSDL2-devel libmcpp-devel
# use system libraries instead build-in
BuildRequires: libwiiuse-devel libraqm-devel

Requires: %name-data >= %version

%description
SuperTuxCart is a kart racing game

%prep
%setup -n %name-%version
%autopatch -p1

sed -i 's|#!/usr/bin/env python|#!/usr/bin/python3|' \
    data/po/update_po_authors.py \
    lib/shaderc/third_party/glslang/build_info.py \
    lib/shaderc/third_party/glslang/gen_extension_headers.py \
    lib/shaderc/third_party/glslang/update_glslang_sources.py \
    lib/shaderc/third_party/re2/benchlog/benchplot.py \
    lib/shaderc/third_party/spirv-tools/utils/check_copyright.py \
    lib/shaderc/third_party/spirv-tools/utils/check_symbol_exports.py \
    lib/shaderc/third_party/spirv-tools/utils/fixup_fuzz_result.py \
    lib/shaderc/third_party/spirv-tools/utils/generate_grammar_tables.py \
    lib/shaderc/third_party/spirv-tools/utils/generate_language_headers.py \
    lib/shaderc/third_party/spirv-tools/utils/generate_registry_tables.py \
    lib/shaderc/third_party/spirv-tools/utils/generate_vim_syntax.py \
    lib/shaderc/third_party/spirv-tools/utils/update_build_version.py \
    lib/shaderc/utils/add_copyright.py \
    lib/shaderc/utils/remove-file-by-suffix.py \
    lib/shaderc/utils/update_build_version.py \
    tools/check_textures.py \
    tools/compute_client_error.py \
    tools/generate-country-names.py

%build
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DUSE_SYSTEM_ANGELSCRIPT=OFF \
    -DBUILD_RECORDER=OFF \
    -DCHECK_ASSETS=OFF \
    -DPROJECT_VERSION=%version \
#
cmake --build %_cmake__builddir -j%__nprocs

%install
#install -d %%buildroot%%_niconsdir
%cmake_install

# The package contains a CVS/.svn/.git/.hg/.bzr/_MTN directory of revision control system.
# It was most likely included by accident since CVS/.svn/.hg/... etc. directories
# usually don't belong in releases.
# When packaging a CVS/SVN snapshot, export from CVS/SVN rather than use a checkout.
find %buildroot -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# the find below is useful in case those CVS/.svn/.git/.hg/.bzr/_MTN directory is added as %%doc
find . -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# built in separate libwiiuse-devel
rm -f %buildroot%_libdir/libwiiuse.a
rm -f %buildroot%_includedir/wiiuse.h

%files
#doc README.md CHANGELOG.md NETWORKING.md
%_bindir/*
%_desktopdir/%name.desktop
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/metainfo/*
# %%_pixmapsdir/*
%_iconsdir/hicolor/16x16/apps/*
%_iconsdir/hicolor/32x32/apps/*
%_iconsdir/hicolor/48x48/apps/*
%_iconsdir/hicolor/64x64/apps/*
%_iconsdir/hicolor/128x128/apps/*
%_iconsdir/hicolor/256x256/apps/*
%_iconsdir/hicolor/512x512/apps/*
%_iconsdir/hicolor/1024x1024/apps/*

%changelog
