%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 46
%define xdg_name org.gnome.NautilusPreviewer
%define api_ver 1.0
%define gst_api_ver 1.0

%def_enable introspection
%def_enable wayland
%def_enable x11
%def_enable check

%define lo_bin %_bindir/libreoffice

Name: sushi
Version: %ver_major.0
Release: alt1

Summary: A quick previewer for Nautilus
License: GPL-2.0-or-later and LGPL-2.1-or-later
Group: Graphical desktop/GNOME
Url: https://gitlab.gnome.org/GNOME/sushi

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gst_ver 1.0
%define webkit_api_ver 4.1
%define webkit_ver 2.38

Requires: gst-plugins-base%gst_api_ver gst-libav
Requires: %lo_bin
Requires: typelib(Gtk) = 3.0
Requires: typelib(GtkSource) = 4
Requires: typelib(WebKit2) = 4.1


BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson
BuildRequires: libgtksourceview4-devel libgjs-devel libharfbuzz-devel
BuildRequires: libevince-devel libepoxy-devel
BuildRequires: pkgconfig(webkit2gtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver gst-plugins%gst_api_ver-devel
%if_enabled introspection
BuildRequires: libgtksourceview4-gir-devel libevince-gir-devel
BuildRequires: libgstreamer%gst_api_ver-gir-devel gst-plugins%gst_api_ver-gir-devel
%endif

%description
This is sushi, a quick previewer for Nautilus, the GNOME desktop file
manager.

%package -n lib%name
Summary: Library for the Sushi project
License: LGPL-2.1-or-later
Group: System/Libraries

%description -n lib%name
Library for Sushi project.

%package -n lib%name-devel
Summary: Development files for Sushi library
License: LGPL-2.1-or-later
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains libraries and header files for developing
applications that use Sushi library.

%package -n lib%name-gir
Summary: GObject introspection data for the Sushi library
License: LGPL-2.1-or-later
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Sushi library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Sushi library
License: LGPL-2.1-or-later
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Sushi library.

%set_typelibdir %_libdir/%name/girepository-1.0

%prep
%setup

%build
%meson \
%{?_disable_wayland:-Dwayland=disabled} \
%{?_disable_x11:-DX11=disabled}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_libexecdir/*
%dir %_libdir/%name
%_libdir/%name/*.so
%dir %_libdir/%name/girepository-1.0
%_libdir/%name/girepository-1.0/Sushi-%api_ver.typelib
%_datadir/%name/
%_datadir/dbus-1/services/*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README* AUTHORS NEWS TODO

%changelog
