Name: sysvinit
Version: 3.00
Release: alt2

%def_enable selinux
%def_enable initramfs

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Summary: Programs which control basic system processes
License: GPLv2+
Group: System/Configuration/Boot and Init
Url: http://savannah.nongnu.org/projects/%name

# ftp://ftp.twaren.net/Unix/NonGNU/%name/%name-%version.tar.bz2
Source: %name-%version.tar

Patch0001: 0001-ALT-Use-program_invocation_short_name-as-progname.patch
Patch0002: 0002-ALT-Mark-usage-functions-as-noreturn.patch
Patch0003: 0003-ALT-Do-not-try-a-few-binaries.patch
Patch0004: 0004-OWL-initcmd_setenv-exclude-INIT_VERSION.patch
Patch0005: 0005-OWL-Fixes.patch
Patch0006: 0006-ALT-Fix-some-build-warnings.patch
Patch0007: 0007-ALT-Add-DISTRO-ALT-to-makefile.patch
Patch0008: 0008-ALT-Change-the-error-message-when-the-getuid-check-f.patch
Patch0009: 0009-ALT-wall-line-size.patch
Patch0010: 0010-ALT-halt-poweroff.patch
Patch0011: 0011-GENTOO-halt-do-kexec-instead-of-reboot-if-another-ke.patch
Patch0012: 0012-Fix-FTBFS-with-glibc-2.28.patch

Provides: SysVinit = %version-%release
Obsoletes: SysVinit < %version-%release

Requires: /sbin/sulogin
Requires: %name-utils = %version-%release
Conflicts: glibc < 6:2.2.1-ipl0.2mdk,
BuildConflicts: openssl-devel < 0.9.6a
# Required for SELinux support.
%{?_enable_selinux:BuildRequires: libselinux-devel}

Conflicts: systemd
Conflicts: systemd-sysvinit

%description
This package contains a group of programs that control the
very basic functions of your system.  sysvinit includes the init
program, the first program started by the Linux kernel when the
system boots.  init then controls the startup, running and shutdown
of all other programs.

%package utils
Summary: Commonly used utilites from sysvinit
Group: System/Base
Conflicts: SysVinit < 2.86-alt2

%description utils
The package contains commonly used non-boot-specific utilities from sysvinit:
bootlogd, killall5, last, lastb, mesg, mountpoint, pidof, pidof, wall.

%if_enabled initramfs
%package initramfs
Summary: Init for initramfs
Group: System/Base

%description initramfs
Simplified version of init (used in initfamfs).
%endif

%prep
%setup
%autopatch -p1

pushd src
find -type f -print0 |
	xargs -r0 grep -FZl '"paths.h"' -- |
	xargs -r0 sed -i 's/"paths\.h"/"paths_init.h"/g' --
mv paths.h paths_init.h
echo '#include <paths.h>' >>paths_init.h
sed -i 's/\<paths\.h\>/paths_init.h/g' -- Makefile
popd

find -type f -name \*.orig -delete

sed -i 's,/run/initctl,/dev/initctl,g' -- man/initctl.5

%build
%if_enabled initramfs
%make_build -C src init \
	DISTRO=ALT \
	CFLAGS='%optflags -fomit-frame-pointer' \
	LDFLAGS= \
	LCRYPT= \
	WITH_SELINUX= \
	#
mv -f src/init{,.initrd}

%make_build -C src clean
%endif

%make_build -C src \
	DISTRO=ALT \
	CFLAGS='%optflags -fomit-frame-pointer' \
	LDFLAGS= \
	LCRYPT= \
	%{?_enable_selinux:WITH_SELINUX=yes} \
	#
%install
mkdir -p %buildroot{/{s,}bin,%_sysconfdir/inittab.d,/dev,/run,%_bindir,%_includedir,%_mandir/man{1,3,5,8}}
%make_install install -C src \
	ROOT=%buildroot \
	DISTRO=ALT \
	#

install -pm755 src/bootlogd src/init.initrd %buildroot/sbin/

mkfifo -m600 %buildroot/dev/initctl
touch %buildroot/run/initctl

# Remove e2fsprogs utility.
rm -f -- %buildroot/sbin/logsave
rm -f -- %buildroot%_man8dir/logsave.*

%pre
# This is tricky.  We don't want to let RPM remove the only link to the
# old init as that would actually leave it pending for delete on process
# termination.  That delete is a filesystem write operation meaning that
# the root filesystem would need to stay mounted read/write.  But we
# absolutely want to be able to remount it read-only during shutdown,
# possibly with the old init still alive!
if [ -e /sbin/init ] && [ ! -e /sbin/.init-working ]; then
	ln /sbin/init /sbin/.init-working
fi

%post
# If /proc is mounted and /sbin/.init-working is running, tell init to
# invoke the replaced version of itself.
if pidof /sbin/.init-working >/dev/null 2>&1; then
	/sbin/telinit u
	sleep 1
fi

# If /proc is not mounted or /sbin/.init-working is no longer running,
# remove it.
if ! pidof /sbin/.init-working >/dev/null 2>&1; then
	rm -f /sbin/.init-working
fi

# Transition to avoid non-rebootable system after upgrade from 2.88
if [ -e /dev/initctl ] && [ -d /run ] && [ ! -e /run/initctl ]; then
	ln -srf /dev/initctl /run/initctl
fi

%files
%attr(700,root,root) /sbin/init
%attr(700,root,root) /sbin/shutdown
%dir %_sysconfdir/inittab.d
/sbin/halt
/sbin/fstab-decode
/sbin/poweroff
/sbin/reboot
/sbin/runlevel
/sbin/telinit
%_man5dir/initscript.*
%_man5dir/inittab.*
%_man5dir/initctl.*
%_man8dir/halt.*
%_man8dir/fstab-decode.*
%_man8dir/init.*
%_man8dir/poweroff.*
%_man8dir/reboot.*
%_man8dir/runlevel.*
%_man8dir/shutdown.*
%_man8dir/telinit.*
%_includedir/*
%ghost /dev/initctl
%ghost /run/initctl

%if_enabled initramfs
%files initramfs
%attr(700,root,root) /sbin/init.initrd
%endif

%files utils
%attr(700,root,root) /sbin/bootlogd
/sbin/killall5
/sbin/pidof
/bin/mountpoint
/bin/pidof
%_bindir/last
%_bindir/lastb
%_bindir/mesg
%_bindir/readbootlog
%attr(2711,root,tty) %_bindir/wall
%_man1dir/last.*
%_man1dir/lastb.*
%_man1dir/mesg.*
%_man1dir/mountpoint.*
%_man1dir/wall.*
%_man1dir/readbootlog.*
%_man8dir/bootlogd.*
%_man8dir/killall5.*
%_man8dir/pidof.*

%changelog
